/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.redis.cluster;

import com.ync365.util.redis.cluster.ClusterJedisLock;
import com.ync365.util.redis.cluster.RedisClusterClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLock {
    private static Logger logger = LoggerFactory.getLogger(SimpleLock.class);
    private static RedisClusterClient redisClient;
    private ClusterJedisLock lock;
    private String lockKey;
    private int timeoutMsecs;
    private int expireMsecs;

    public SimpleLock(String lockKey) {
        this.lockKey = "LOCK:" + lockKey;
        this.lock = new ClusterJedisLock(redisClient, this.lockKey.intern());
    }

    public SimpleLock(String lockKey, int timeoutMsecs, int expireMsecs) {
        this.lockKey = "LOCK:" + lockKey;
        this.timeoutMsecs = timeoutMsecs;
        this.expireMsecs = expireMsecs;
        this.lock = new ClusterJedisLock(redisClient, this.lockKey.intern(), timeoutMsecs, expireMsecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrap(Runnable runnable) {
        long begin = System.currentTimeMillis();
        try {
            logger.info("begin logck,lockKey={},timeoutMsecs={},expireMsecs={}", new Object[]{this.lockKey, this.timeoutMsecs, this.expireMsecs});
            if (this.lock.acquire()) {
                runnable.run();
            } else {
                logger.info("The time wait for lock more than [{}] ms ", (Object)this.timeoutMsecs);
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        finally {
            this.lockRelease(this.lock);
        }
        logger.info("[{}]cost={}", (Object)this.lockKey, (Object)(System.currentTimeMillis() - begin));
    }

    private void lockRelease(ClusterJedisLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.info("release logck,lockKey={},timeoutMsecs={},expireMsecs={}", new Object[]{this.lockKey, this.timeoutMsecs, this.expireMsecs});
    }

    public static synchronized void setJedisClient(RedisClusterClient redisClient) {
        SimpleLock.redisClient = redisClient;
    }

    public static synchronized void destory() {
        redisClient = null;
    }
}

