/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.redis;

import com.ync365.util.redis.RedisShardClient;
import com.ync365.util.redis.ShardedJedisLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLock {
    private static Logger logger = LoggerFactory.getLogger(SimpleLock.class);
    private static RedisShardClient redisClient;
    private ShardedJedisLock lock;
    private String lockKey;
    private int timeoutMsecs;
    private int expireMsecs;

    public SimpleLock(String lockKey) {
        this.lockKey = "LOCK:" + lockKey;
        this.lock = new ShardedJedisLock(redisClient, this.lockKey.intern());
    }

    public SimpleLock(String lockKey, int timeoutMsecs, int expireMsecs) {
        this.lockKey = "LOCK:" + lockKey;
        this.timeoutMsecs = timeoutMsecs;
        this.expireMsecs = expireMsecs;
        this.lock = new ShardedJedisLock(redisClient, this.lockKey.intern(), timeoutMsecs, expireMsecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrap(Runnable runnable) {
        long begin = System.currentTimeMillis();
        try {
            logger.info("begin logck,lockKey={},timeoutMsecs={},expireMsecs={}", new Object[]{this.lockKey, this.timeoutMsecs, this.expireMsecs});
            if (this.lock.acquire()) {
                runnable.run();
            } else {
                logger.info("The time wait for lock more than [{}] ms ", (Object)this.timeoutMsecs);
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        finally {
            this.lockRelease(this.lock);
        }
        logger.info("[{}]cost={}", (Object)this.lockKey, (Object)(System.currentTimeMillis() - begin));
    }

    private void lockRelease(ShardedJedisLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.info("release logck,lockKey={},timeoutMsecs={},expireMsecs={}", new Object[]{this.lockKey, this.timeoutMsecs, this.expireMsecs});
    }

    public static synchronized void setShardedJedisClient(RedisShardClient redisClient) {
        SimpleLock.redisClient = redisClient;
    }

    public static synchronized void destory() {
        redisClient = null;
    }
}

