/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.redis;

import com.ync365.util.redis.RedisShardClient;

public class ShardedJedisLock {
    RedisShardClient redisShardClient;
    String lockKey;
    int expireMsecs = 60000;
    int timeoutMsecs = 10000;
    boolean locked = false;

    public ShardedJedisLock(RedisShardClient redisShardClient, String lockKey) {
        this.redisShardClient = redisShardClient;
        this.lockKey = lockKey;
    }

    public ShardedJedisLock(RedisShardClient redisShardClient, String lockKey, int timeoutMsecs) {
        this(redisShardClient, lockKey);
        this.timeoutMsecs = timeoutMsecs;
    }

    public ShardedJedisLock(RedisShardClient redisShardClient, String lockKey, int timeoutMsecs, int expireMsecs) {
        this(redisShardClient, lockKey, timeoutMsecs);
        this.expireMsecs = expireMsecs;
    }

    public ShardedJedisLock(String lockKey) {
        this(null, lockKey);
    }

    public ShardedJedisLock(String lockKey, int timeoutMsecs) {
        this(null, lockKey, timeoutMsecs);
    }

    public ShardedJedisLock(String lockKey, int timeoutMsecs, int expireMsecs) {
        this(null, lockKey, timeoutMsecs, expireMsecs);
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public synchronized boolean acquire() throws InterruptedException {
        return this.acquire(this.redisShardClient);
    }

    public synchronized boolean acquire(RedisShardClient redisShardClient) throws InterruptedException {
        for (int timeout = this.timeoutMsecs; timeout >= 0; timeout -= 100) {
            String oldValueStr;
            long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
            String expiresStr = String.valueOf(expires);
            if (redisShardClient.setnx(this.lockKey, expiresStr) == 1L) {
                this.locked = true;
                return true;
            }
            String currentValueStr = redisShardClient.get(this.lockKey);
            if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis() && (oldValueStr = redisShardClient.getSet(this.lockKey, expiresStr)) != null && oldValueStr.equals(currentValueStr)) {
                this.locked = true;
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public synchronized void release() {
        this.release(this.redisShardClient);
    }

    public synchronized void release(RedisShardClient redisShardClient) {
        if (this.locked) {
            redisShardClient.del(this.lockKey);
            this.locked = false;
        }
    }
}

