/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.redis;

import redis.clients.jedis.Jedis;

public class JedisLock {
    Jedis jedis;
    String lockKey;
    int expireMsecs = 60000;
    int timeoutMsecs = 10000;
    boolean locked = false;

    public JedisLock(Jedis jedis, String lockKey) {
        this.jedis = jedis;
        this.lockKey = lockKey;
    }

    public JedisLock(Jedis jedis, String lockKey, int timeoutMsecs) {
        this(jedis, lockKey);
        this.timeoutMsecs = timeoutMsecs;
    }

    public JedisLock(Jedis jedis, String lockKey, int timeoutMsecs, int expireMsecs) {
        this(jedis, lockKey, timeoutMsecs);
        this.expireMsecs = expireMsecs;
    }

    public JedisLock(String lockKey) {
        this(null, lockKey);
    }

    public JedisLock(String lockKey, int timeoutMsecs) {
        this(null, lockKey, timeoutMsecs);
    }

    public JedisLock(String lockKey, int timeoutMsecs, int expireMsecs) {
        this(null, lockKey, timeoutMsecs, expireMsecs);
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public synchronized boolean acquire() throws InterruptedException {
        return this.acquire(this.jedis);
    }

    public synchronized boolean acquire(Jedis jedis) throws InterruptedException {
        for (int timeout = this.timeoutMsecs; timeout >= 0; timeout -= 100) {
            String oldValueStr;
            long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
            String expiresStr = String.valueOf(expires);
            if (jedis.setnx(this.lockKey, expiresStr) == 1L) {
                this.locked = true;
                return true;
            }
            String currentValueStr = jedis.get(this.lockKey);
            if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis() && (oldValueStr = jedis.getSet(this.lockKey, expiresStr)) != null && oldValueStr.equals(currentValueStr)) {
                this.locked = true;
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public synchronized void release() {
        this.release(this.jedis);
    }

    public synchronized void release(Jedis jedis) {
        if (this.locked) {
            jedis.del(this.lockKey);
            this.locked = false;
        }
    }
}

