/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.sso.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IPUtil {
    private static Logger logger = LoggerFactory.getLogger(IPUtil.class);

    private IPUtil() {
    }

    public static String getIp() {
        String hostIp = null;
        if (hostIp == null) {
            ArrayList<String> ips = new ArrayList<String>();
            Enumeration<NetworkInterface> netInterfaces = null;
            try {
                netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = netInterfaces.nextElement();
                    Enumeration<InetAddress> inteAddresses = netInterface.getInetAddresses();
                    while (inteAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inteAddresses.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                        ips.add(inetAddress.getHostAddress());
                    }
                }
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            hostIp = IPUtil.collectionToDelimitedString(ips, ",");
        }
        return hostIp;
    }

    private static String collectionToDelimitedString(Collection<String> coll, String delim) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = coll.iterator();
        while (it.hasNext()) {
            sb.append((Object)it.next());
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String getHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return hostName;
    }
}

