/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.util;

import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    public static ResultDTO call(String url, RequestBody body) {
        ResultDTO dto = null;
        try {
            Request.Builder builder = new Request.Builder().url(url);
            if (body != null) {
                builder.post(body);
            }
            Request request = builder.build();
            OkHttpClient okHttpClient = new OkHttpClient();
            Call call = okHttpClient.newCall(request);
            Response response = call.execute();
            String result = response.body().string();
            dto = new ResultDTO(result);
        }
        catch (IOException e) {
            dto = new ResultDTO("", e.getMessage());
        }
        return dto;
    }

    public static ResultDTO doGet(String url) {
        return OkHttpUtil.call(url, null);
    }

    public static ResultDTO doFormPost(String url, Map<String, String> mapData) {
        FormBody.Builder builder = new FormBody.Builder();
        if (mapData != null) {
            for (Map.Entry<String, String> data : mapData.entrySet()) {
                builder.add(data.getKey(), data.getValue());
            }
        }
        return OkHttpUtil.call(url, (RequestBody)builder.build());
    }

    public static ResultDTO doJsonPost(String url, String jsonData) {
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonData);
        return OkHttpUtil.call(url, body);
    }

    public static class ResultDTO {
        private Boolean isSuccess = false;
        private String result;
        private String exceptionMsg;

        public ResultDTO(String result) {
            this.isSuccess = true;
            this.result = result;
        }

        public ResultDTO(String result, String exceptionMsg) {
            this.isSuccess = false;
            this.result = result;
            this.exceptionMsg = exceptionMsg;
        }

        public ResultDTO(Boolean isSuccess, String result, String exceptionMsg) {
            this.isSuccess = isSuccess;
            this.result = result;
            this.exceptionMsg = exceptionMsg;
        }

        public Boolean getIsSuccess() {
            return this.isSuccess;
        }

        public void setIsSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getExceptionMsg() {
            return this.exceptionMsg;
        }

        public void setExceptionMsg(String exceptionMsg) {
            this.exceptionMsg = exceptionMsg;
        }
    }
}

