/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.util;

import com.sun.crypto.provider.SunJCE;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class CodecUtils {
    private static final Base64 B64 = new Base64();
    private static final SecureRandom RANDOM = new SecureRandom();
    private static MessageDigest SHA_1 = null;
    private static String CHARSET = "UTF-8";
    private static final String DES_ALGORITHM = "DESede";
    private static Cipher DES_CIPHER_ENC;
    private static Cipher DES_CIPHER_DEC;
    private static final String AES_ALGORITHM = "AES";

    private CodecUtils() {
    }

    private static void init() {
        try {
            SHA_1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String sha1(String str) {
        return new String(B64.encode(SHA_1.digest(str.getBytes())));
    }

    public static String sha1Url(String str) {
        return new String(Base64.encodeBase64URLSafeString((byte[])SHA_1.digest(str.getBytes())));
    }

    public static byte[] b64Encode(byte[] bs) {
        return B64.encode(bs);
    }

    public static String b64Encode(String str) {
        if (null != str) {
            return new String(B64.encode(str.getBytes()));
        }
        return null;
    }

    public static String b64Url(String str) {
        if (null != str) {
            return Base64.encodeBase64URLSafeString((byte[])str.getBytes());
        }
        return null;
    }

    public static byte[] b64Decode(byte[] bs) {
        return B64.decode(bs);
    }

    public static String b64Decode(String str) {
        byte[] bs;
        if (null != str && null != (bs = B64.decode(str.getBytes()))) {
            return new String(bs);
        }
        return null;
    }

    public static String md5(String str) {
        if (null != str) {
            return DigestUtils.md5Hex((String)str);
        }
        return null;
    }

    public static String desEncryp(String str) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return CodecUtils.desEncryp(str, false);
    }

    public static String desEncrypUrl(String str) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return CodecUtils.desEncryp(str, true);
    }

    public static String desEncryp(String str, boolean urlSafety) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (null != str) {
            byte[] bytes = DES_CIPHER_ENC.doFinal(str.getBytes(CHARSET));
            if (urlSafety) {
                return Base64.encodeBase64URLSafeString((byte[])bytes);
            }
            return new String(B64.encode(bytes));
        }
        return null;
    }

    public static String desDecrypt(String str) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (null != str) {
            byte[] bytes = DES_CIPHER_DEC.doFinal(B64.decode(str));
            return new String(bytes, CHARSET);
        }
        return null;
    }

    public static String desEncryp(String str, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return CodecUtils.desEncryp(str, key, false);
    }

    public static String desEncrypUrl(String str, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return CodecUtils.desEncryp(str, key, true);
    }

    public static String desEncryp(String str, String key, boolean urlSafety) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (null != str && null != key) {
            Cipher c = Cipher.getInstance(DES_ALGORITHM);
            c.init(1, (Key)CodecUtils.desKey(key), RANDOM);
            byte[] bytes = c.doFinal(str.getBytes(CHARSET));
            if (urlSafety) {
                return Base64.encodeBase64URLSafeString((byte[])bytes);
            }
            return new String(B64.encode(bytes));
        }
        return null;
    }

    public static String desDecrypt(String str, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (null != str && null != key) {
            Cipher c = Cipher.getInstance(DES_ALGORITHM);
            c.init(2, (Key)CodecUtils.desKey(key), RANDOM);
            byte[] bytes = c.doFinal(B64.decode(str));
            return new String(bytes, CHARSET);
        }
        return null;
    }

    private static SecretKey desKey(String key) {
        byte[] bs = key.getBytes();
        if (bs.length != 24) {
            bs = Arrays.copyOf(bs, 24);
        }
        return new SecretKeySpec(bs, DES_ALGORITHM);
    }

    public static String aesEncryp(String str, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return CodecUtils.aesEncryp(str, key, false);
    }

    public static String aesEncrypUrl(String str, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return CodecUtils.aesEncryp(str, key, true);
    }

    public static String aesEncryp(String str, String key, boolean urlSafety) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (null != str && null != key) {
            Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
            c.init(1, (Key)CodecUtils.aesKey(key), RANDOM);
            byte[] bytes = c.doFinal(str.getBytes(CHARSET));
            if (urlSafety) {
                return Base64.encodeBase64URLSafeString((byte[])bytes);
            }
            return new String(B64.encode(bytes));
        }
        return null;
    }

    public static String aesDecrypt(String str, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        if (null != str && null != key) {
            Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
            c.init(2, (Key)CodecUtils.aesKey(key), RANDOM);
            return new String(c.doFinal(B64.decode(str)), CHARSET);
        }
        return null;
    }

    private static SecretKeySpec aesKey(String key) {
        byte[] bs = key.getBytes();
        if (bs.length != 16) {
            bs = Arrays.copyOf(bs, 16);
        }
        return new SecretKeySpec(bs, AES_ALGORITHM);
    }

    static {
        CodecUtils.init();
        DES_CIPHER_ENC = null;
        DES_CIPHER_DEC = null;
        Security.addProvider(new SunJCE());
        try {
            SecretKeySpec desKey = new SecretKeySpec(new byte[]{17, 34, 79, 88, -120, 16, 64, 56, 40, 37, 121, 81, -53, -35, 85, 102, 119, 41, 116, -104, 48, 64, 54, -30}, DES_ALGORITHM);
            DES_CIPHER_ENC = Cipher.getInstance(DES_ALGORITHM);
            DES_CIPHER_ENC.init(1, (Key)desKey, RANDOM);
            DES_CIPHER_DEC = Cipher.getInstance(DES_ALGORITHM);
            DES_CIPHER_DEC.init(2, (Key)desKey, RANDOM);
        }
        catch (Exception e) {
            throw new RuntimeException("DES\u9ed8\u8ba4\u52a0\u5bc6\u89e3\u5bc6\u521d\u59cb\u5316\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }
}

