package com.ync365.sso.service.common;

import java.io.Serializable;

/**
 * @author piaohailin
 */
public final class MessageDTO implements Serializable {
    private static final long serialVersionUID = -4365891554943581287L;
    /**
     * 调用是否成功
     */
    private boolean           success;
    /**
     * 错误码
     */
    private String            errorCode;
    /**
     * 错误信息
     */
    private String            errorMessage;

    /**
     * 调用事务ID
     */
    private String            callId;

    /**
     * 调用时间戳
     */
    private long              timestamp;

    /**
     * 方法执行耗时
     */
    private long              cost;

    /**
     * 服务器IP
     */
    private String            ip;

    /**
     * 服务器名称
     */
    private String            hostName;

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getCallId() {
        return callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getCost() {
        return cost;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String toString() {
        return "MessageDTO [success=" + success + ", errorCode=" + errorCode + ", errorMessage=" + errorMessage + ", callId=" + callId + ", timestamp=" + timestamp + ", cost=" + cost + ", ip=" + ip + ", hostName=" + hostName + "]";
    }
}
