package com.jxwk.sso.client.util;

import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ync365.sso.util.ConstantUtil.AccessPolicy;

/**
 * 
 * XML解析工具<br>
 * 
 * @author Administrator
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class XmlParserUtil {

    /**
     * 
     * 功能描述: 根据xml文件流创建Configuration对象<br>
     *
     * @param is
     * @return
     * @throws Exception
     * @see [相关类/方法](可选)
     * @since [产品/模块版本](可选)
     */
    public static SsoConfig parseXmlToSsoConfig(InputStream is) throws Exception {
        try {
            if (is == null) {
                // 数据流为空
            }
            DocumentBuilder dbd = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dbd.parse(is);
            XPath path = XPathFactory.newInstance().newXPath();
            Node ssoConfigureRoot = getNode(path, doc, "sso-configure");
            if (ssoConfigureRoot == null) {
                // sso-configure节点为空
            }
            
            SsoConfig ssoConfig = new SsoConfig();
            // 应用编码
            String appcode = getString(path, ssoConfigureRoot, "app-code");
            if (null != appcode && !"".equals(appcode)) {
                ssoConfig.setAppcode(appcode);
			}
            
            // (业务系统)登录后跳转地址
			String indexUrl = getString(path, ssoConfigureRoot, "index-url");
			if (null != indexUrl && !"".equals(indexUrl)) {
				ssoConfig.setIndexUrl(indexUrl);
			}
            
            // Cookie的作用域
            String cookieDomain = getString(path, ssoConfigureRoot, "cookie-domain");
            if (null != cookieDomain && !"".equals(cookieDomain)) {
                ssoConfig.setCookieDomain(cookieDomain);
            }
            
//            // redis的地址及端口
//            String redisAdress = getString(path, ssoConfigureRoot, "redis-adress");
//            if (null != redisAdress && !"".equals(redisAdress)) {
//                ssoConfig.setRedisAdress(redisAdress);
//            }
            
            // 本地登录地址
            String logoutUrl = getString(path, ssoConfigureRoot, "logout-url");
            if (null != logoutUrl && !"".equals(logoutUrl)) {
                ssoConfig.setLogoutUrl(logoutUrl);
            }
            
            // 用户中心地址
            String usercenterServerUrl = getString(path, ssoConfigureRoot, "usercenter-server-url");
            if (null != usercenterServerUrl && !"".equals(usercenterServerUrl)) {
                ssoConfig.setUsercenterServerUrl(usercenterServerUrl);
            }
            
            // 认证中心地址
//            String passportServerUrl = getString(path, ssoConfigureRoot, "passport-server-url");
//            if (null != passportServerUrl && !"".equals(passportServerUrl)) {
//                ssoConfig.setPassportServerUrl(passportServerUrl);
//            }
            
            // 票据认证中心地址
            String ticketServerUrl = getString(path, ssoConfigureRoot, "ticket-server-url");
            if (null != ticketServerUrl && !"".equals(ticketServerUrl)) {
                ssoConfig.setTicketServerUrl(ticketServerUrl + ssoConfig.getTicketServerUrl());
                ssoConfig.setTicketAjaxServerUrl(ticketServerUrl + ssoConfig.getTicketAjaxServerUrl());
            }
            
            // thrift服务地址
            String serverUrl = getString(path, ssoConfigureRoot, "server-url");
            if (null != serverUrl && !"".equals(serverUrl)) {
                ssoConfig.setServerUrl(serverUrl);
            }
            
            // 默认跳转地址
//            String defaultUrl = getString(path, ssoConfigureRoot, "default-url");
//            if (null != defaultUrl && !"".equals(defaultUrl)) {
//                ssoConfig.setDefaultUrl(defaultUrl);
//            }
            
            // 销毁ehcache地址(业务系统)
            String clearEhcacheUrl = getString(path, ssoConfigureRoot, "clear-ehcache-url");
            if (null != clearEhcacheUrl && !"".equals(clearEhcacheUrl)) {
                ssoConfig.setClearEhcacheUrl(clearEhcacheUrl);
            }
            
            String secretKey = getString(path, ssoConfigureRoot, "secret-key");
            if (null != secretKey && !"".equals(secretKey)) {
            	ssoConfig.setSecretKey(secretKey);
            }
            return ssoConfig;
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (Exception e) {

            }
        }
    }

    /**
     * 
     * 功能描述: 根据输入流，解析出AccessSetting对象<br>
     *
     * @param is
     * @return
     * @throws Exception
     * @see [相关类/方法](可选)
     * @since [产品/模块版本](可选)
     */
    public static SsoAccess parseXmlToAccessSetting(InputStream is) throws Exception {
        try {
            if (is == null) {
                // 数据流为空
            }
            DocumentBuilder dbd = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dbd.parse(is);
            XPath path = XPathFactory.newInstance().newXPath();
            Node ssoAccessPolicyRoot = getNode(path, doc, "sso-access");
            if (null == ssoAccessPolicyRoot) {
                // 配置信息错误
            }

            SsoAccess accessSetting = new SsoAccess();

            // 获取受限资源集合
            NodeList limitList = getList(path, ssoAccessPolicyRoot, "limit/url-pattern");
            for (int i = 0; i < limitList.getLength(); i++) {
                Node node = limitList.item(i);
                accessSetting.addLimitPattern(node.getTextContent().trim());
            }

            // 获取非受限资源
            NodeList undefinedList = getList(path, ssoAccessPolicyRoot, "undefined/url-pattern");
            for (int i = 0; i < undefinedList.getLength(); i++) {
                Node node = undefinedList.item(i);
                accessSetting.addUndefinedPattern(node.getTextContent().trim());
            }

            // 获取getway资源
            NodeList passList = getList(path, ssoAccessPolicyRoot, "pass/url-pattern");
            for (int i = 0; i < passList.getLength(); i++) {
                Node node = passList.item(i);
                accessSetting.addPassPattern(node.getTextContent().trim());
            }

            String defaultAccessPolicy = getString(path, ssoAccessPolicyRoot, "default-access");
            if (defaultAccessPolicy != null && !"".equals(defaultAccessPolicy.trim())) {
                AccessPolicy policy = AccessPolicy.valueOf(defaultAccessPolicy);
                if (policy == null) {
                    // 未设置默认访问策略
                    policy = AccessPolicy.UNDEFINED;
                }
                accessSetting.setDefaultAccessPolicy(AccessPolicy.valueOf(defaultAccessPolicy));
            }

            return accessSetting;
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (Exception e) {

            }
        }
    }

    // 获取xPath中指定表达式的值
    private static String getString(XPath path,
                                    Object node,
                                    String expression) throws XPathExpressionException {
        return (String) path.evaluate(expression, node, XPathConstants.STRING);
    }

    private static NodeList getList(XPath path,
                                    Object node,
                                    String expression) throws XPathExpressionException {
        return (NodeList) path.evaluate(expression, node, XPathConstants.NODESET);
    }

    private static Node getNode(XPath path,
                                Object node,
                                String expression) throws XPathExpressionException {
        return (Node) path.evaluate(expression, node, XPathConstants.NODE);
    }
}
