package com.jxwk.sso.client.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.jxwk.sso.client.AuthenticationFilter;
import com.jxwk.sso.client.Configuration;
import com.jxwk.util.MD5Util;
import com.jxwk.util.OkHttpUtil;
import com.jxwk.util.OkHttpUtil.ResultDTO;
import com.ync365.sso.service.dto.BooleanDTO;
import com.ync365.sso.service.dto.SessionDTO;
import com.ync365.sso.service.dto.UserDTO;
import com.ync365.sso.util.ConstantUtil;
import com.ync365.sso.util.CookieUtil;
import com.ync365.sso.util.JacksonMapperUtil;

import net.sf.ehcache.Element;

public class SsoRemoteService {

	public static BooleanDTO saveAppClearEhcacheUrl(String clearEhcacheUrl) {
		Configuration config = AuthenticationFilter.configuration;
		BooleanDTO resp = null;
		try {
			String timestamp = "" + (new Date()).getTime();
			String sign = MD5Util.getMD5(clearEhcacheUrl + timestamp + config.getSsoConfig().getSecretKey());

			Map<String, String> mapData = new HashMap<String, String>();
			String str = "appip=" + clearEhcacheUrl + "&timestamp=" + timestamp + "&sign=" + sign;
			String str2 = com.jxwk.util.CodecUtils.aesEncrypUrl(str, config.getSsoConfig().getSecretKey());
			
			ResultDTO rslt = OkHttpUtil.doFormPost(config.getSsoConfig().getServerUrl() + "/saveAppip/" + str2, mapData);// 调用远程接口
			if (Boolean.TRUE.equals(rslt.getIsSuccess())) {
				resp = JacksonMapperUtil.jsonToBean(rslt.getResult(), BooleanDTO.class);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return resp;
	}

	public static boolean checkWhiteList(String domain) {
		Configuration config = AuthenticationFilter.configuration;
        // 获取应用编码
        String appCode = config.getSsoConfig().getAppcode();
		boolean isWhiteList = false;
		try {
			String timestamp = "" + (new Date()).getTime();
			String sign = MD5Util.getMD5(appCode + domain + timestamp + config.getSsoConfig().getSecretKey());

			Map<String, String> mapData = new HashMap<String, String>();
			String str = "appcode=" + appCode + "&domain=" + domain + "&timestamp=" + timestamp + "&sign=" + sign;
			String str2 = com.jxwk.util.CodecUtils.aesEncrypUrl(str, config.getSsoConfig().getSecretKey());
			ResultDTO rslt = OkHttpUtil.doFormPost(config.getSsoConfig().getServerUrl() + "/checkWhiteList/" + str2, mapData);// 调用远程接口
			
			if (Boolean.TRUE.equals(rslt.getIsSuccess())) {
				isWhiteList = JacksonMapperUtil.jsonToBean(rslt.getResult(), Boolean.class);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return isWhiteList;
	}

	public static SessionDTO getSession(String sid) {
		Configuration config = AuthenticationFilter.configuration;
		SessionDTO sessionDTO = null;

		try {
			String timestamp = "" + (new Date()).getTime();
			String sign = MD5Util.getMD5(sid + timestamp + config.getSsoConfig().getSecretKey());

			Map<String, String> mapData = new HashMap<String, String>();
			// mapData.put("sessionKey", sessionKey);
			// mapData.put("timestamp", timestamp);
			// mapData.put("sign", sign);

			String str = "sid=" + sid + "&timestamp=" + timestamp + "&sign=" + sign;
			String str2 = com.jxwk.util.CodecUtils.aesEncrypUrl(str, config.getSsoConfig().getSecretKey());
			ResultDTO rslt = OkHttpUtil.doFormPost(config.getSsoConfig().getServerUrl() + "/getSession/" + str2, mapData);// 调用远程接口
			
			if (Boolean.TRUE.equals(rslt.getIsSuccess())) {
				sessionDTO = JacksonMapperUtil.jsonToBean(rslt.getResult(), SessionDTO.class);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return sessionDTO;
	}

	public static UserDTO getUser(HttpServletRequest request) {

		Configuration config = AuthenticationFilter.configuration;
        // 获取应用编码
        String appCode = config.getSsoConfig().getAppcode();
		String uid = null;
        String yncsid = request.getParameter(ConstantUtil.YNCSID);
        if(yncsid == null || yncsid.isEmpty()){
            yncsid = CookieUtil.getCookieValue(request, ConstantUtil.YNCSID);
        }
        if (null != yncsid && !"".equals(yncsid)) {
            SessionDTO sessionDTO = null;
            Element element = config.getEhcacheClient().getCache().get(yncsid);
            if (null == element) {
                synchronized (yncsid.intern()) {
                    element = config.getEhcacheClient().getCache().get(yncsid);
                    if (null == element) {
                        sessionDTO = SsoRemoteService.getSession(yncsid);
                    }
                }
            } else {
                sessionDTO = (SessionDTO) element.getObjectValue();
            }
            if(sessionDTO!=null && sessionDTO.getYnctgt()!=null){
            	uid = sessionDTO.getYnctgt().getYncuid();
            }
        }
        UserDTO user = null;
		if(uid!=null && !uid.isEmpty()){
			try {
				String timestamp = "" + (new Date()).getTime();
				String sign = MD5Util.getMD5(uid + timestamp + config.getSsoConfig().getSecretKey());

				Map<String, String> mapData = new HashMap<String, String>();
				String str = "appcode=" + appCode + "&uid=" + uid + "&timestamp=" + timestamp + "&sign=" + sign;
				String str2 = com.jxwk.util.CodecUtils.aesEncrypUrl(str, config.getSsoConfig().getSecretKey());
				ResultDTO rslt = OkHttpUtil.doFormPost(config.getSsoConfig().getServerUrl() + "/getUser/" + str2, mapData);// 调用远程接口
				
				if (Boolean.TRUE.equals(rslt.getIsSuccess())) {
					user = JacksonMapperUtil.jsonToBean(rslt.getResult(), UserDTO.class);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return user;
	}
	
	public static String getLogoutUrl(String defaultUrl){
		SsoConfig config = AuthenticationFilter.configuration.getSsoConfig();
		String logoutUrl = config.getLogoutUrl();
		logoutUrl += "?ac=" + config.getAppcode();
		logoutUrl += "&service=" + defaultUrl;
		return logoutUrl;
	}
	
	public static String getLogoutUrl(){
		SsoConfig config = AuthenticationFilter.configuration.getSsoConfig();
		return getLogoutUrl(config.getIndexUrl());
	}
	
	public static boolean isFilterInitialized(){
		return AuthenticationFilter.configuration.isInitialized();
	}
}
