package com.jxwk.sso.client.util;

import java.util.ArrayList;
import java.util.List;

import com.ync365.sso.util.ConstantUtil.AccessPolicy;

/**
 * 
 * 匹配请求地址，并判断地址的访问策略<br>
 * 
 * @author Administrator
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class SsoAccess {

    /**
     * 定义默认访问策略，默认放行
     */
    private AccessPolicy defaultAccessPolicy = AccessPolicy.PASS;

    /**
     * 受限资源地址集合
     */
    private List<String> limitList           = new ArrayList<String>();
    /**
     * 非受限资源地址集合
     */
    private List<String> undefinedList       = new ArrayList<String>();
    /**
     * Gateway地址集合
     */
    private List<String> passList            = new ArrayList<String>();

    protected void addLimitPattern(String pattern) {
        limitList.add(pattern);
    }

    protected void addUndefinedPattern(String pattern) {
        undefinedList.add(pattern);
    }

    protected void addPassPattern(String pattern) {
        passList.add(pattern);
    }

    public void setDefaultAccessPolicy(AccessPolicy defaultAccessPolicy) {
        this.defaultAccessPolicy = defaultAccessPolicy;
    }

    /**
     * 
     * 功能描述: 校验请求地址所属访问策略<br>
     *
     * @param uri 请求地址
     * @return
     */
    public AccessPolicy matchAccessPolicy(String uri) {

        if (MatcherUtil.matching(uri, this.undefinedList)) {
            return AccessPolicy.UNDEFINED;
        }

        if (MatcherUtil.matching(uri, this.limitList)) {
            return AccessPolicy.LIMIT;
        }

        if (MatcherUtil.matching(uri, this.passList)) {
            return AccessPolicy.PASS;
        }

        return defaultAccessPolicy;
    }
}
