package com.jxwk.sso.client.util;

import java.util.List;

/**
 * 
 * 〈访问路径匹配工具类〉<br>
 * 
 * @author chentianyu
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class MatcherUtil {

    private static AntPathMatcher pathMatcher = new AntPathMatcher();

    /**
     * 功能描述: 将uri与patterns进行匹配，如果匹配成功则返回true，否则返回false<br>
     * <ul>
     * <li>不完整路径uri方式路径匹配</li>
     * 请求路径: String requestPath="/app/pub/login.do"; 路径匹配模式 : String patternPath="/~~/login.do";
     *
     * <li>糊路径方式匹配</li>
     * 请求路径: String requestPath="/app/pub/login.do"; 路径匹配模式: String patternPath="/~~/*.do";
     * <li>包含模糊单字符路径匹配
     * <li>
     * 请求路径 : String requestPath = "/app/pub/login.do"; 路径匹配模式 : String patternPath = "/~~/login.do";
     * </ul>
     * 
     * @param uri 目标uri
     * @param patterns 匹配规则uri集合
     * @return true：匹配成功 false：匹配失败
     * @see [相关类/方法](可选)
     * @since [产品/模块版本](可选)
     */
    public static boolean matching(String uri,
                                   List<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        for (String pattern : patterns) {
            if (pathMatcher.match(pattern, uri)) {
                return true;
            }
        }
        return false;
    }
}
