package com.jxwk.sso.client.util;

import java.net.URL;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;

/**
 * 
 * 功能描述：Ehcache客户端<br>
 * 
 * @author chentianyu
 */
public class EhcacheClient {

    private CacheManager manager;

    private Cache        cache;

    /**
     * 
     * 功能描述: 初始化<br>
     *
     */
    public void init() {
        URL url = EhcacheClient.class.getClassLoader().getResource("ehcache.xml");
        Configuration configuration = ConfigurationFactory.parseConfiguration(url);
        configuration.setName("_ssoCacheManager2017_");
        manager = new CacheManager(configuration);
        cache = manager.getCache("ssoClientCache");
    }

    public void destroy() {
        cache.dispose();
        cache = null;
        manager.shutdown();
    }

    public Cache getCache() {
        return cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public CacheManager getManager() {
        return manager;
    }

    public void setManager(CacheManager manager) {
        this.manager = manager;
    }
}
