package com.jxwk.sso.client;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import com.ync365.sso.service.dto.SessionDTO;

/**
 * 
 * 自定义HttpServlerRequestWrapper<br>
 * 
 * @author chentianyu
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class SsoHttpServletRequestWrapper extends HttpServletRequestWrapper {

    private final SessionDTO sessionDTO;

    SsoHttpServletRequestWrapper(final HttpServletRequest request, final SessionDTO sessionDTO) {
        super(request);
        this.sessionDTO = sessionDTO;
    }

    public String getRemoteUser() {
        return sessionDTO != null ? sessionDTO.getYnctgt().getYncuid() : null;
    }

}
