package com.jxwk.sso.client;

import javax.servlet.ServletRequest;

/**
 * 
 * 功能描述：请求拦截结果对象<br>
 * 
 * @author chentianyu
 */
public class InterceptResult {

    /**
     * 是否结束当前请求
     */
    private boolean        reqeustHasEnd = true;

    /**
     * 是否在白名单中
     */
    private boolean        isWhiteList   = false;

    private ServletRequest servletRequestWrapper;

    /**
     * 构造函数
     * 
     * @param reqeustHasEnd 是否走filter true：走filter false：提前跳转
     * @param isWhiteList 是否白名单
     * @param servletRequestWrapper
     */
    public InterceptResult(boolean reqeustHasEnd, boolean isWhiteList, ServletRequest servletRequestWrapper) {
        this.reqeustHasEnd = reqeustHasEnd;
        this.isWhiteList = isWhiteList;
        this.servletRequestWrapper = servletRequestWrapper;
    }

    public ServletRequest getServletRequestWrapper() {
        return servletRequestWrapper;
    }

    public void setServletRequestWrapper(ServletRequest servletRequestWrapper) {
        this.servletRequestWrapper = servletRequestWrapper;
    }

    public boolean isReqeustHasEnd() {
        return reqeustHasEnd;
    }

    public void setReqeustHasEnd(boolean reqeustHasEnd) {
        this.reqeustHasEnd = reqeustHasEnd;
    }

    public boolean isWhiteList() {
        return isWhiteList;
    }

    public void setWhiteList(boolean isWhiteList) {
        this.isWhiteList = isWhiteList;
    }
}
