package com.jxwk.sso.client;

import java.io.InputStream;

import javax.servlet.ServletException;

import com.jxwk.sso.client.util.EhcacheClient;
import com.jxwk.sso.client.util.SsoAccess;
import com.jxwk.sso.client.util.SsoConfig;
import com.jxwk.sso.client.util.SsoRemoteService;
import com.jxwk.sso.client.util.XmlParserUtil;

/**
 * 
 * 功能描述：<br>
 * <li>1.初始化sso-config.xml，完成客户端调用sso的各种配置信息的初始化</li> <li>2.初始化sso-access.xml，完成受限资源地址信息的初始化</li> <li>3.初始化hessian客户端工厂类
 * </li> <li>4.初始化Redis客户端</li>
 * 
 * @author chentianyu
 */
public class Configuration {
	
	private boolean initialized;
	
	/**
	 * hessian客户端工厂类
	 */
//    private HessianClientFactory hessianClientFactory   = new HessianClientFactory();
//	private HessianClientFactory thriftClientFactory = new HessianClientFactory();
    
    /**
     * 定义配置对象
     */
    private SsoConfig            ssoConfig            = new SsoConfig();

    /**
     * 定义访问策略对象
     */
    private SsoAccess            ssoAccess            = new SsoAccess();

//    /**
//     * Redis客户端
//     */
//    private RedisShardClient     redisClient          = new RedisShardClient();
    /**
     * Ehcache客户端
     */
    private EhcacheClient		 ehcacheClient          = new EhcacheClient();
    
    /**
     * sso-config输入流
     */
    private InputStream inputStreamConfig;
    /**
     * sso-access输入流
     */
    private InputStream inputStreamAccess;
	
	/**
	 * 
	 * 功能描述: 容器初始化<br>
	 * @throws ServletException
	 */
	public void init() throws ServletException{
		try{
			//读取sso-config.xml内容
			ssoConfig = XmlParserUtil.parseXmlToSsoConfig(this.getInputStreamConfig());
			AuthenticationFilter.configuration.setSsoConfig(ssoConfig);
			
			//读取sso-access.xml内容
			ssoAccess = XmlParserUtil.parseXmlToAccessSetting(this.getInputStreamAccess());
			AuthenticationFilter.configuration.setSsoAccess(ssoAccess);
			
//	        //设置thriftServiceUrl
//			hessianClientFactory.setServiceUrl(ssoConfig.getServerUrl());
//	        // 初始化
//			hessianClientFactory.init();
//	        AuthenticationFilter.configuration.setHessianClientFactory(hessianClientFactory);
	        
//	        //redis地址设置
//	        redisClient.setAddresses(ssoConfig.getRedisAdress());
//	        //redis初始化
//	        redisClient.init();
//	        AuthenticationFilter.configuration.setRedisClient(redisClient);
	        
	        //初始化Ehcache
	        ehcacheClient.init();
	        AuthenticationFilter.configuration.setEhcacheClient(ehcacheClient);
	        
	        //将服务器的销毁ehcache地址传递给sso服务器
//	        hessianClientFactory.getSsoService().saveAppip(ssoConfig.getClearEhcacheUrl());
	        SsoRemoteService.saveAppClearEhcacheUrl(ssoConfig.getClearEhcacheUrl());
	        
	        initialized = true;
	    	
		} catch (Exception ex) {
			
		}
	}


    /**
     * 功能描述: 对象销毁方法<br>
     *
     */
    public void destory() {
//        try {
//            hessianClientFactory.destory();
//        } catch (Exception e) {
//        }
//        try {
//            redisClient.destory();
//        } catch (Exception e) {
//        }
    }

//    public HessianClientFactory getHessianClientFactory() {
//		return hessianClientFactory;
//	}
//
//	public void setHessianClientFactory(HessianClientFactory thriftClientFactory) {
//		this.hessianClientFactory = hessianClientFactory;
//	}
//
//	public RedisShardClient getRedisClient() {
//        return redisClient;
//    }
//
//    public void setRedisClient(RedisShardClient redisClient) {
//        this.redisClient = redisClient;
//    }

    public SsoAccess getSsoAccess() {
        return ssoAccess;
    }

    public void setSsoAccess(SsoAccess ssoAccess) {
        this.ssoAccess = ssoAccess;
    }

    public EhcacheClient getEhcacheClient() {
        return ehcacheClient;
    }

    public void setEhcacheClient(EhcacheClient ehcacheClient) {
        this.ehcacheClient = ehcacheClient;
    }

    public SsoConfig getSsoConfig() {
        return ssoConfig;
    }

    public void setSsoConfig(SsoConfig ssoConfig) {
        this.ssoConfig = ssoConfig;
    }

	public InputStream getInputStreamConfig() {
		return inputStreamConfig;
	}

	public void setInputStreamConfig(InputStream inputStreamConfig) {
		this.inputStreamConfig = inputStreamConfig;
	}

	public InputStream getInputStreamAccess() {
		return inputStreamAccess;
	}

	public void setInputStreamAccess(InputStream inputStreamAccess) {
		this.inputStreamAccess = inputStreamAccess;
	}

	public boolean isInitialized() {
		return initialized;
	}
}
