package com.jxwk.sso.client;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * 
 * 功能描述：客户端核心过滤器，所有的请求均需要通过此过滤器进行登录校验<br>
 * 
 * @author chentianyu
 */
public class AuthenticationFilter implements Filter {
	
	/**
	 * sso-config.xml文件初始化路径标识
	 */
	private static final String SSO_CONFIG_FILE_PATH 	= "ssoConfigFilePath";
	/**
	 * sso-access.xml文件初始化路径标识
	 */
	private static final String SSO_ACCESS_FILE_PATH 	= "ssoAccessFilePath";

    public static Configuration   configuration         = new Configuration();

    private AuthenticationService authenticationService = new AuthenticationService();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // 获取该filter的初始化上下文
    	ServletContext servletContext = filterConfig.getServletContext();
    	
    	//从web.xml中读取sso-config.xml和sso-access.xml配置路径
    	String ssoConfigFilePath = servletContext.getInitParameter(SSO_CONFIG_FILE_PATH);
    	InputStream inputStreamConfig = servletContext.getResourceAsStream(ssoConfigFilePath);
    	String ssoAccessPolicyFilePath = servletContext.getInitParameter(SSO_ACCESS_FILE_PATH);
    	InputStream inputStreamAccess = servletContext.getResourceAsStream(ssoAccessPolicyFilePath);
    	configuration.setInputStreamConfig(inputStreamConfig);
    	configuration.setInputStreamAccess(inputStreamAccess);
        
        // 初始化业务逻辑对象
        authenticationService.init();

        // 初始化客户端配置对象
        configuration.init();
    }

    @Override
    public void destroy() {
        if (authenticationService != null) {
            authenticationService.destory();
        }
        if (configuration != null) {
            configuration.destory();
            configuration = null;
        }
    }

    @Override
    public void doFilter(ServletRequest servletRequest,
                         ServletResponse servletResponse,
                         FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        // 资源验证
        InterceptResult interceptResult = authenticationService.intercept(servletRequest, servletResponse, AuthenticationFilter.configuration);
        // 白名单验证、domain、sid
        if (interceptResult.isWhiteList()) {
            // 判断是否进行doFilter
            if (interceptResult.isReqeustHasEnd()) {
                filterChain.doFilter(interceptResult.getServletRequestWrapper(), response);
            }
        } else {
            // 当前请求不在白名单中，sso-status用于调试
            //response.setHeader("sso-status", "false");
            filterChain.doFilter(servletRequest, response);
        }
    }

    public AuthenticationService getAuthenticationService() {
        return authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}
