/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.log.aspect;

import com.jxwk.sso.business.biz.SysAccessLogBiz;
import com.jxwk.sso.business.biz.SysErrorLogBiz;
import com.jxwk.sso.business.log.annotation.SystemLog;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SystemLogAspect {
    @Autowired
    private SysAccessLogBiz sysAccessLogBiz;
    @Autowired
    private SysErrorLogBiz sysErrorLogBiz;
    private static final Logger logger = LoggerFactory.getLogger(SystemLogAspect.class);

    @Pointcut(value="@annotation(com.jxwk.sso.business.log.annotation.SystemLog)")
    public void systemAspect() {
    }

    @Before(value="systemAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    @AfterThrowing(pointcut="systemAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
    }

    public static String getMthodDesc(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String description = "";
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            description = method.getAnnotation(SystemLog.class).desc();
            break;
        }
        return description;
    }

    private String getMethodName(JoinPoint joinPoint) {
        return joinPoint.getTarget().getClass().getName() + "." + joinPoint.getSignature().getName() + "()";
    }

    private String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

