/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jxwk.sso.business.enums.ResourceTypeEnum;
import com.jxwk.sso.business.enums.ValueEnumUtils;
import com.jxwk.sso.business.vo.SelectTreeCompVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.format.annotation.DateTimeFormat;

@Table(name="SYS_RESOURCE")
public class SysResource
implements Serializable,
SelectTreeCompVO {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private String id;
    @Column(name="name")
    private String name;
    @Column(name="code")
    private String code;
    @Column(name="type")
    private Integer type;
    @Transient
    private String typeName;
    @Column(name="url")
    private String url;
    @Column(name="permission")
    private String permission;
    @Column(name="parent_id")
    private String parentId;
    @Column(name="create_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @Column(name="create_by")
    private String createBy;
    @Column(name="sort")
    private Short sort;
    @Column(name="remark")
    private String remark;
    @Column(name="depth")
    private Integer depth;
    @Column(name="icon")
    private String icon;
    @Column(name="is_mobile")
    private Boolean isMobile;
    @Column(name="appcode")
    private String appcode;
    @Column(name="app_uid")
    private String appUid;
    @Column(name="app_sync_log_id")
    private String appSyncLogId;
    @Transient
    private Boolean checked = false;
    @Transient
    private List<SysResource> children = new ArrayList<SysResource>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Short getSort() {
        return this.sort;
    }

    public void setSort(Short sort) {
        this.sort = sort;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Boolean getIsMobile() {
        return this.isMobile;
    }

    public void setIsMobile(Boolean isMobile) {
        this.isMobile = isMobile;
    }

    public String getAppcode() {
        return this.appcode;
    }

    public void setAppcode(String appcode) {
        this.appcode = appcode;
    }

    public String getAppUid() {
        return this.appUid;
    }

    public void setAppUid(String appUid) {
        this.appUid = appUid;
    }

    public String getAppSyncLogId() {
        return this.appSyncLogId;
    }

    public void setAppSyncLogId(String appSyncLogId) {
        this.appSyncLogId = appSyncLogId;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public List<SysResource> getChildren() {
        return this.children;
    }

    public void setChildren(List<SysResource> children) {
        this.children = children;
    }

    public String getTypeName() {
        return ValueEnumUtils.getEnumNameByValue(ResourceTypeEnum.class, this.type);
    }

    @Override
    public Object getSelectCompId() {
        return this.id;
    }

    @Override
    public Object getSelectCompName() {
        return this.name + " [" + this.code + "]";
    }

    @Override
    public Object getSelectCompPid() {
        return this.parentId;
    }
}

