/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.MSysRoleSysResource;
import com.jxwk.sso.business.entity.MSysUserSysRole;
import com.jxwk.sso.business.entity.SysLogAuditPolicy;
import com.jxwk.sso.business.entity.SysRole;
import com.jxwk.sso.business.mapper.MSysRoleSysResourceDao;
import com.jxwk.sso.business.mapper.MSysUserSysRoleDao;
import com.jxwk.sso.business.mapper.SysLogAuditPolicyDao;
import com.jxwk.sso.business.mapper.SysRoleDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysRoleBiz {
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private MSysRoleSysResourceDao mSysRoleSysResourceDao;
    @Autowired
    private MSysUserSysRoleDao mSysUserSysRoleDao;
    @Autowired
    private SysLogAuditPolicyDao auditPolicyDao;

    @Transactional
    public int insert(SysRole entity, String resourceIds) {
        entity.setCreateTime(new Date());
        int i = this.sysRoleDao.insertSelective(entity);
        if (i > 0 && StringUtil.isNotBlank((String)resourceIds)) {
            List<String> resList = Arrays.asList(resourceIds.split(","));
            ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
            for (String res : resList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("resourceId", res.split("\\|")[0]);
                map.put("resourceType", res.split("\\|")[1]);
                maplist.add(map);
            }
            this.sysRoleDao.saveRoleMRessource(maplist, entity.getId());
        }
        return i;
    }

    @Transactional
    public int update(SysRole entity, String resourceIds) {
        int i = this.sysRoleDao.updateByPrimaryKeySelective(entity);
        if (i > 0) {
            this.sysRoleDao.deleteRoleMRessource(entity.getId());
            if (StringUtil.isNotBlank((String)resourceIds)) {
                List<String> resList = Arrays.asList(resourceIds.split(","));
                ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
                for (String res : resList) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("resourceId", res.split("\\|")[0]);
                    map.put("resourceType", res.split("\\|")[1]);
                    maplist.add(map);
                }
                this.sysRoleDao.saveRoleMRessource(maplist, entity.getId());
            }
        }
        return i;
    }

    @Transactional
    public int delete(String id) {
        int i = this.sysRoleDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.sysRoleDao.deleteRoleMRessource(id);
            Example example = new Example(SysLogAuditPolicy.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("roleId", (Object)id);
            this.auditPolicyDao.deleteByExample(example);
        }
        return i;
    }

    public SysRole selectById(String id) {
        SysRole entity = (SysRole)this.sysRoleDao.selectByPrimaryKey(id);
        return entity;
    }

    public List<SysRole> selectByAppUid(String appUid, String appcode) {
        Example example = new Example(SysRole.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("appUid", (Object)appUid);
        criteria.andEqualTo("appcode", (Object)appcode);
        List list = this.sysRoleDao.selectByExample(example);
        return list;
    }

    public List<SysRole> selectByCondition(String name) {
        Example example = new Example(SysRole.class);
        Example.Criteria c = example.createCriteria();
        example.setOrderByClause("create_time desc");
        if (name != null && name.trim().length() > 0) {
            c.andLike("name", "%" + name + "%");
        }
        return this.sysRoleDao.selectByExample(example);
    }

    public Page<SysRole> selectPageByCondition(PageRequest pr, String name) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"create_time desc");
        Page list = (Page)this.selectByCondition(name);
        return list;
    }

    public List<SysRole> selectUserIdRole(String userId) {
        return this.sysRoleDao.selectUserIdRole(userId);
    }

    public List<MSysRoleSysResource> selectByRoleIdAndResourceId(String roleId, String resourceId) {
        Example example = new Example(MSysRoleSysResource.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("roleId", (Object)roleId);
        criteria.andEqualTo("resourceId", (Object)resourceId);
        List list = this.mSysRoleSysResourceDao.selectByExample(example);
        return list;
    }

    public int insertRoleAndResource(String roleId, String resourceId) {
        ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("resourceId", resourceId);
        map.put("resourceType", "0");
        maplist.add(map);
        return this.sysRoleDao.saveRoleMRessource(maplist, roleId);
    }

    public List<MSysUserSysRole> getSysUserAndRole(String userId, String roleId) {
        Example example = new Example(MSysUserSysRole.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("sysUserId", (Object)userId);
        criteria.andEqualTo("sysRoleId", (Object)roleId);
        List list = this.mSysUserSysRoleDao.selectByExample(example);
        return list;
    }

    public int insertSysUserAndRole(String userId, String roleId) {
        MSysUserSysRole mSysUserSysRole = new MSysUserSysRole();
        mSysUserSysRole.setSysUserId(userId);
        mSysUserSysRole.setSysRoleId(roleId);
        return this.mSysUserSysRoleDao.insertSelective(mSysUserSysRole);
    }
}

