/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.jxwk.sso.business.entity.SysResource;
import com.jxwk.sso.business.mapper.SysResourceDao;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysResourceBiz {
    @Autowired
    private SysResourceDao sysResourceDao;

    @Transactional
    public int insert(SysResource entity) {
        entity.setCreateTime(new Date());
        int i = this.sysResourceDao.insertSelective(entity);
        return i;
    }

    @Transactional
    public int update(SysResource entity) {
        int i = this.sysResourceDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    @Transactional
    public int delete(String id) {
        int i = this.sysResourceDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.sysResourceDao.deleteRoleMRessource(id);
        }
        return i;
    }

    public SysResource selectById(String id) {
        SysResource entity = (SysResource)this.sysResourceDao.selectByPrimaryKey(id);
        return entity;
    }

    public List<SysResource> selectByAppUid(String appUid, String appcode) {
        Example example = new Example(SysResource.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("appUid", (Object)appUid);
        criteria.andEqualTo("appcode", (Object)appcode);
        List list = this.sysResourceDao.selectByExample(example);
        return list;
    }

    public List<SysResource> selectByCondition(String appcode, String name, String code) {
        Example example = new Example(SysResource.class);
        Example.Criteria c = example.createCriteria();
        example.setOrderByClause("sort asc");
        if (name != null && name.trim().length() > 0) {
            c.andLike("name", "%" + name + "%");
        }
        if (code != null && code.trim().length() > 0) {
            c.andEqualTo("code", (Object)code);
        }
        if (appcode != null && appcode.trim().length() > 0) {
            c.andEqualTo("appcode", (Object)appcode);
        }
        return this.sysResourceDao.selectByExample(example);
    }

    public List<SysResource> findAllResource(String appcode) {
        return this.sysResourceDao.findAllResource(appcode);
    }

    public List<SysResource> findResourceByRoleId(String roleId, String appcode) {
        return this.sysResourceDao.findResourceByRoleId(roleId, appcode);
    }

    public List<SysResource> selectRoleIdRessource(String userId) {
        return this.sysResourceDao.selectRoleIdRessource(userId);
    }
}

