/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.biz.SysLogAuditPolicyBiz;
import com.jxwk.sso.business.entity.SysLog;
import com.jxwk.sso.business.mapper.SysLogDao;
import com.jxwk.sso.business.pagination.Page;
import com.jxwk.sso.business.pagination.PageBuilder;
import com.jxwk.sso.business.pagination.PageRequest;
import com.jxwk.util.DataFormatUtils;
import com.ync365.sso.util.JacksonMapperUtil;
import com.ync365.sso.util.RedisShardUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysLogBiz {
    @Autowired
    private SysLogDao sysLogDao;
    @Autowired
    private SysLogAuditPolicyBiz auditPolicyBiz;

    public Page<SysLog> findSysLogList(PageRequest pageRequest) {
        PageHelper.startPage((int)pageRequest.getPageNo(), (int)pageRequest.getPageSize(), (String)" CREAT_TIME DESC");
        Example example = new Example(SysLog.class);
        List list = this.sysLogDao.selectByExample(example);
        int total = this.sysLogDao.selectCountByExample(example);
        return PageBuilder.buildPage(pageRequest, list, total);
    }

    public int save(String logModule, String logContent) {
        SysLog sysLog = new SysLog();
        sysLog.setLogName("admin");
        sysLog.setLogModule(logModule);
        sysLog.setLogContent(logContent);
        sysLog.setCreatTime(new Date());
        sysLog.setLogIp("127.0.0.1");
        sysLog.setLogAccount("admin");
        return this.sysLogDao.insertSelective(sysLog);
    }

    public int save(SysLog entity) {
        return this.sysLogDao.insertSelective(entity);
    }

    public List<Map<String, Object>> selectSysLogList(String logName) {
        Example example = new Example(SysLog.class);
        Example.Criteria criteria = example.createCriteria();
        if (logName != null && !logName.equals("")) {
            criteria.andLike("logName", "%" + logName + "%");
        }
        List list = this.sysLogDao.selectByExample(example);
        return list;
    }

    public List<Map<String, Object>> selectSysLogListByParams(Map<String, Object> params, String userId) {
        List list = null;
        Example logExample = new Example(SysLog.class);
        Example.Criteria logCriteria = logExample.createCriteria();
        logExample.setOrderByClause("creatTime desc");
        Set<String> modules = this.auditPolicyBiz.getCurrentAuditPolicy(userId);
        if (!modules.isEmpty()) {
            logCriteria.andIn("logModule", new ArrayList<String>(modules));
        }
        if (!params.isEmpty()) {
            if (params.containsKey("logName") && null != params.get("logName") && !"".equals(params.get("logName"))) {
                logCriteria.andLike("logName", "%" + params.get("logName") + "%");
            }
            if (params.containsKey("logModule") && null != params.get("logModule") && !"".equals(params.get("logModule"))) {
                logCriteria.andEqualTo("logModule", params.get("logModule"));
            }
            if (params.containsKey("beginTime") && null != params.get("beginTime") && !"".equals(params.get("beginTime"))) {
                logCriteria.andGreaterThanOrEqualTo("creatTime", (Object)DataFormatUtils.dateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)params.get("beginTime").toString()));
            }
            if (params.containsKey("endTime") && null != params.get("endTime") && !"".equals(params.get("endTime"))) {
                logCriteria.andLessThanOrEqualTo("creatTime", (Object)DataFormatUtils.dateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)params.get("endTime").toString()));
            }
        }
        if (logCriteria.getCriteria().size() > 1) {
            list = this.sysLogDao.selectByExample(logExample);
        } else {
            String redisList = RedisShardUtil.getData((String)("logList" + modules));
            if (null == redisList || redisList.isEmpty()) {
                list = this.sysLogDao.selectByExample(logExample);
                RedisShardUtil.saveData((String)("logList" + modules), (String)JacksonMapperUtil.listToJson((List)list), (int)100);
            } else {
                list = JacksonMapperUtil.jsonToList((String)redisList, SysLog.class);
            }
        }
        return list;
    }
}

