/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.SysDictData;
import com.jxwk.sso.business.entity.SysDictGroup;
import com.jxwk.sso.business.mapper.SysDictDataDao;
import com.jxwk.sso.business.mapper.SysDictGroupDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysDictGroupBiz {
    @Autowired
    private SysDictGroupDao sysDictGroupDao;
    @Autowired
    private SysDictDataDao sysDictDataDao;

    private boolean checkBeforeSave(SysDictGroup entity) {
        int cnt;
        boolean rst = true;
        if (StringUtil.isBlank((String)entity.getCode())) {
            rst = false;
            throw new IllegalArgumentException("\u5206\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example ex = new Example(SysDictGroup.class);
        Example.Criteria crit = ex.or().andCondition("upper(code)=", (Object)entity.getCode().toUpperCase());
        if (StringUtil.isNotBlank((String)entity.getId())) {
            crit.andNotEqualTo("id", (Object)entity.getId());
        }
        if ((cnt = this.sysDictGroupDao.selectCountByExample(ex)) > 0) {
            rst = false;
            throw new IllegalArgumentException("\u5206\u7ec4\u7f16\u7801\u51b2\u7a81");
        }
        return rst;
    }

    @Transactional
    public int insert(SysDictGroup entity) {
        if (this.checkBeforeSave(entity)) {
            entity.setCreateTime(new Date());
            int i = this.sysDictGroupDao.insertSelective(entity);
            return i;
        }
        return -1;
    }

    @CacheEvict(value={"sso_cache"}, allEntries=true)
    @Transactional
    public int update(SysDictGroup entity) {
        if (this.checkBeforeSave(entity)) {
            int i = this.sysDictGroupDao.updateByPrimaryKeySelective(entity);
            return i;
        }
        return -1;
    }

    @Transactional
    public int delete(String id) {
        SysDictGroup sysDictGroup = (SysDictGroup)this.sysDictGroupDao.selectByPrimaryKey(id);
        int i = this.sysDictGroupDao.deleteByPrimaryKey(id);
        if (i > 0) {
            SysDictData record = new SysDictData();
            record.setGcode(sysDictGroup.getCode());
            this.sysDictDataDao.delete(record);
        }
        return i;
    }

    public SysDictGroup selectById(String id) {
        SysDictGroup entity = (SysDictGroup)this.sysDictGroupDao.selectByPrimaryKey(id);
        return entity;
    }

    public List<SysDictGroup> selectByCondition(String code, String name) {
        Example example = new Example(SysDictGroup.class);
        Example.Criteria crit = example.createCriteria();
        example.setOrderByClause("code asc");
        if (StringUtil.isNotBlank((String)code)) {
            crit.andLike("code", "%" + code + "%");
        }
        if (StringUtil.isNotBlank((String)name)) {
            crit.andLike("name", "%" + name + "%");
        }
        List list = this.sysDictGroupDao.selectByExample(example);
        return list;
    }

    public Page<SysDictGroup> selectPageByCondition(PageRequest pr, String code, String label) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"code asc");
        Page list = (Page)this.selectByCondition(code, label);
        return list;
    }
}

