/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.SsoApplication;
import com.jxwk.sso.business.mapper.SsoApplicationDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.DateUtil;
import com.ync365.sso.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SsoApplicationBiz {
    @Autowired
    private SsoApplicationDao ssoApplicationDao;

    @Transactional
    public int insert(SsoApplication entity) {
        entity.setRegdate(DateUtil.getNowDatetime());
        entity.setDeleted(false);
        entity.setCreateTime(new Date());
        int i = this.ssoApplicationDao.insertSelective(entity);
        return i;
    }

    @Transactional
    public int update(SsoApplication entity) {
        int i = this.ssoApplicationDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    @Transactional
    public int delete(String id) {
        SsoApplication entity = new SsoApplication(id, true);
        int i = this.ssoApplicationDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    public SsoApplication selectById(String id) {
        SsoApplication entity = (SsoApplication)this.ssoApplicationDao.selectByPrimaryKey(id);
        return entity;
    }

    public List<SsoApplication> selectByCondition(String appname, String appcode) {
        Example example = new Example(SsoApplication.class);
        Example.Criteria crit = example.createCriteria();
        crit.andEqualTo("deleted", (Object)false);
        if (StringUtil.isNotBlank((String)appname)) {
            crit.andLike("appname", "%" + appname + "%");
        }
        if (StringUtil.isNotBlank((String)appcode)) {
            crit.andEqualTo("appcode", (Object)appcode);
        }
        List list = this.ssoApplicationDao.selectByExample(example);
        return list;
    }

    public Page<SsoApplication> selectPageByCondition(PageRequest pr, String appname, String appcode) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"appcode");
        Page list = (Page)this.selectByCondition(appname, appcode);
        return list;
    }

    public List<SsoApplication> findByUserId(String userId) {
        return this.ssoApplicationDao.findByUserId(userId);
    }
}

