/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.msg;

import com.serotonin.modbus4j.Modbus;
import com.serotonin.modbus4j.ProcessImage;
import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.msg.WriteCoilsResponse;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public class WriteCoilsRequest
extends ModbusRequest {
    private int startOffset;
    private int numberOfBits;
    private byte[] data;

    public WriteCoilsRequest(int slaveId, int startOffset, boolean[] bdata) throws ModbusTransportException {
        super(slaveId);
        this.startOffset = startOffset;
        this.numberOfBits = bdata.length;
        this.data = this.convertToBytes(bdata);
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.startOffset);
        modbus.validateNumberOfBits(this.numberOfBits);
        ModbusUtils.validateEndOffset(this.startOffset + this.numberOfBits - 1);
    }

    WriteCoilsRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.startOffset);
        ModbusUtils.pushShort(queue, this.numberOfBits);
        ModbusUtils.pushByte(queue, this.data.length);
        queue.push(this.data);
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        boolean[] bdata = this.convertToBooleans(this.data);
        for (int i = 0; i < this.numberOfBits; ++i) {
            processImage.writeCoil(this.startOffset + i, bdata[i]);
        }
        return new WriteCoilsResponse(this.slaveId, this.startOffset, this.numberOfBits);
    }

    @Override
    public byte getFunctionCode() {
        return 15;
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new WriteCoilsResponse(slaveId);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.startOffset = ModbusUtils.popUnsignedShort(queue);
        this.numberOfBits = ModbusUtils.popUnsignedShort(queue);
        this.data = new byte[ModbusUtils.popUnsignedByte(queue)];
        queue.pop(this.data);
    }
}

