/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.msg;

import com.serotonin.modbus4j.ProcessImage;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.msg.ReadBinaryRequest;
import com.serotonin.modbus4j.msg.ReadCoilsResponse;

public class ReadCoilsRequest
extends ReadBinaryRequest {
    public ReadCoilsRequest(int slaveId, int startOffset, int numberOfBits) throws ModbusTransportException {
        super(slaveId, startOffset, numberOfBits);
    }

    ReadCoilsRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    public byte getFunctionCode() {
        return 1;
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        return new ReadCoilsResponse(this.slaveId, this.getData(processImage));
    }

    @Override
    protected boolean getBinary(ProcessImage processImage, int index) throws ModbusTransportException {
        return processImage.getCoil(index);
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new ReadCoilsResponse(slaveId);
    }

    @Override
    public String toString() {
        return "ReadCoilsRequest [slaveId=" + this.slaveId + ", getFunctionCode()=" + this.getFunctionCode() + ", toString()=" + super.toString() + "]";
    }
}

