/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.locator;

import com.serotonin.modbus4j.exception.IllegalDataTypeException;
import com.serotonin.modbus4j.locator.BaseLocator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.lang3.ArrayUtils;

public class NumericLocator
extends BaseLocator<Number> {
    private static final int[] DATA_TYPES = new int[]{2, 3, 22, 23, 4, 5, 6, 7, 24, 25, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20};
    private final int dataType;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;

    public NumericLocator(int slaveId, int range, int offset, int dataType) {
        super(slaveId, range, offset);
        this.dataType = dataType;
        this.validate();
    }

    private void validate() {
        super.validate(this.getRegisterCount());
        if (this.range == 1 || this.range == 2) {
            throw new IllegalDataTypeException("Only binary values can be read from Coil and Input ranges");
        }
        if (!ArrayUtils.contains((int[])DATA_TYPES, (int)this.dataType)) {
            throw new IllegalDataTypeException("Invalid data type");
        }
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public String toString() {
        return "NumericLocator(slaveId=" + this.getSlaveId() + ", range=" + this.range + ", offset=" + this.offset + ", dataType=" + this.dataType + ")";
    }

    @Override
    public int getRegisterCount() {
        switch (this.dataType) {
            case 2: 
            case 3: 
            case 16: 
            case 22: 
            case 23: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 24: 
            case 25: {
                return 2;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return 4;
            }
        }
        throw new RuntimeException("Unsupported data type: " + this.dataType);
    }

    @Override
    public Number bytesToValueRealOffset(byte[] data, int offset) {
        offset *= 2;
        if (this.dataType == 2) {
            return new Integer((data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF);
        }
        if (this.dataType == 3) {
            return new Short((short)((data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF));
        }
        if (this.dataType == 22) {
            return new Integer((data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF);
        }
        if (this.dataType == 23) {
            return new Short((short)((data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF));
        }
        if (this.dataType == 16) {
            StringBuilder sb = new StringBuilder();
            NumericLocator.appendBCD(sb, data[offset]);
            NumericLocator.appendBCD(sb, data[offset + 1]);
            return Short.parseShort(sb.toString());
        }
        if (this.dataType == 4) {
            return new Long((long)(data[offset] & 0xFF) << 24 | (long)(data[offset + 1] & 0xFF) << 16 | (long)(data[offset + 2] & 0xFF) << 8 | (long)(data[offset + 3] & 0xFF));
        }
        if (this.dataType == 5) {
            return new Integer((data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF);
        }
        if (this.dataType == 6) {
            return new Long((long)(data[offset + 2] & 0xFF) << 24 | (long)(data[offset + 3] & 0xFF) << 16 | (long)(data[offset] & 0xFF) << 8 | (long)(data[offset + 1] & 0xFF));
        }
        if (this.dataType == 7) {
            return new Integer((data[offset + 2] & 0xFF) << 24 | (data[offset + 3] & 0xFF) << 16 | (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF);
        }
        if (this.dataType == 24) {
            return new Long((long)(data[offset + 3] & 0xFF) << 24 | (long)((data[offset + 2] & 0xFF) << 16) | (long)(data[offset + 1] & 0xFF) << 8 | (long)(data[offset] & 0xFF));
        }
        if (this.dataType == 25) {
            return new Integer((data[offset + 3] & 0xFF) << 24 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF);
        }
        if (this.dataType == 8) {
            return Float.valueOf(Float.intBitsToFloat((data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF));
        }
        if (this.dataType == 9) {
            return Float.valueOf(Float.intBitsToFloat((data[offset + 2] & 0xFF) << 24 | (data[offset + 3] & 0xFF) << 16 | (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF));
        }
        if (this.dataType == 17) {
            StringBuilder sb = new StringBuilder();
            NumericLocator.appendBCD(sb, data[offset]);
            NumericLocator.appendBCD(sb, data[offset + 1]);
            NumericLocator.appendBCD(sb, data[offset + 2]);
            NumericLocator.appendBCD(sb, data[offset + 3]);
            return Integer.parseInt(sb.toString());
        }
        if (this.dataType == 20) {
            StringBuilder sb = new StringBuilder();
            NumericLocator.appendBCD(sb, data[offset + 2]);
            NumericLocator.appendBCD(sb, data[offset + 3]);
            NumericLocator.appendBCD(sb, data[offset]);
            NumericLocator.appendBCD(sb, data[offset + 1]);
            return Integer.parseInt(sb.toString());
        }
        if (this.dataType == 10) {
            byte[] b9 = new byte[9];
            System.arraycopy(data, offset, b9, 1, 8);
            return new BigInteger(b9);
        }
        if (this.dataType == 11) {
            return new Long((long)(data[offset] & 0xFF) << 56 | (long)(data[offset + 1] & 0xFF) << 48 | (long)(data[offset + 2] & 0xFF) << 40 | (long)(data[offset + 3] & 0xFF) << 32 | (long)(data[offset + 4] & 0xFF) << 24 | (long)(data[offset + 5] & 0xFF) << 16 | (long)(data[offset + 6] & 0xFF) << 8 | (long)(data[offset + 7] & 0xFF));
        }
        if (this.dataType == 12) {
            byte[] b9 = new byte[9];
            b9[1] = data[offset + 6];
            b9[2] = data[offset + 7];
            b9[3] = data[offset + 4];
            b9[4] = data[offset + 5];
            b9[5] = data[offset + 2];
            b9[6] = data[offset + 3];
            b9[7] = data[offset];
            b9[8] = data[offset + 1];
            return new BigInteger(b9);
        }
        if (this.dataType == 13) {
            return new Long((long)(data[offset + 6] & 0xFF) << 56 | (long)(data[offset + 7] & 0xFF) << 48 | (long)(data[offset + 4] & 0xFF) << 40 | (long)(data[offset + 5] & 0xFF) << 32 | (long)(data[offset + 2] & 0xFF) << 24 | (long)(data[offset + 3] & 0xFF) << 16 | (long)(data[offset] & 0xFF) << 8 | (long)(data[offset + 1] & 0xFF));
        }
        if (this.dataType == 14) {
            return Double.longBitsToDouble((long)(data[offset] & 0xFF) << 56 | (long)(data[offset + 1] & 0xFF) << 48 | (long)(data[offset + 2] & 0xFF) << 40 | (long)(data[offset + 3] & 0xFF) << 32 | (long)(data[offset + 4] & 0xFF) << 24 | (long)(data[offset + 5] & 0xFF) << 16 | (long)(data[offset + 6] & 0xFF) << 8 | (long)(data[offset + 7] & 0xFF));
        }
        if (this.dataType == 15) {
            return Double.longBitsToDouble((long)(data[offset + 6] & 0xFF) << 56 | (long)(data[offset + 7] & 0xFF) << 48 | (long)(data[offset + 4] & 0xFF) << 40 | (long)(data[offset + 5] & 0xFF) << 32 | (long)(data[offset + 2] & 0xFF) << 24 | (long)(data[offset + 3] & 0xFF) << 16 | (long)(data[offset] & 0xFF) << 8 | (long)(data[offset + 1] & 0xFF));
        }
        throw new RuntimeException("Unsupported data type: " + this.dataType);
    }

    private static void appendBCD(StringBuilder sb, byte b) {
        sb.append(NumericLocator.bcdNibbleToInt(b, true));
        sb.append(NumericLocator.bcdNibbleToInt(b, false));
    }

    private static int bcdNibbleToInt(byte b, boolean high) {
        int n = high ? b >> 4 & 0xF : b & 0xF;
        if (n > 9) {
            n = 0;
        }
        return n;
    }

    @Override
    public short[] valueToShorts(Number value) {
        if (this.dataType == 2 || this.dataType == 3) {
            return new short[]{this.toShort(value)};
        }
        if (this.dataType == 23 || this.dataType == 22) {
            short sval = this.toShort(value);
            return new short[]{(short)((sval & 0xFF00) >> 8 | (sval & 0xFF) << 8)};
        }
        if (this.dataType == 16) {
            short s = this.toShort(value);
            return new short[]{(short)(s / 1000 % 10 << 12 | s / 100 % 10 << 8 | s / 10 % 10 << 4 | s % 10)};
        }
        if (this.dataType == 4 || this.dataType == 5) {
            int i = this.toInt(value);
            return new short[]{(short)(i >> 16), (short)i};
        }
        if (this.dataType == 6 || this.dataType == 7) {
            int i = this.toInt(value);
            return new short[]{(short)i, (short)(i >> 16)};
        }
        if (this.dataType == 25 || this.dataType == 24) {
            int i = this.toInt(value);
            short topWord = (short)((i & 0xFF) << 8 | i >> 8 & 0xFF);
            short bottomWord = (short)(i >> 24 & 0xFF | i >> 8 & 0xFF00);
            return new short[]{topWord, bottomWord};
        }
        if (this.dataType == 8) {
            int i = Float.floatToIntBits(value.floatValue());
            return new short[]{(short)(i >> 16), (short)i};
        }
        if (this.dataType == 9) {
            int i = Float.floatToIntBits(value.floatValue());
            return new short[]{(short)i, (short)(i >> 16)};
        }
        if (this.dataType == 17) {
            int i = this.toInt(value);
            return new short[]{(short)(i / 10000000 % 10 << 12 | i / 1000000 % 10 << 8 | i / 100000 % 10 << 4 | i / 10000 % 10), (short)(i / 1000 % 10 << 12 | i / 100 % 10 << 8 | i / 10 % 10 << 4 | i % 10)};
        }
        if (this.dataType == 10 || this.dataType == 11) {
            long l = value.longValue();
            return new short[]{(short)(l >> 48), (short)(l >> 32), (short)(l >> 16), (short)l};
        }
        if (this.dataType == 12 || this.dataType == 13) {
            long l = value.longValue();
            return new short[]{(short)l, (short)(l >> 16), (short)(l >> 32), (short)(l >> 48)};
        }
        if (this.dataType == 14) {
            long l = Double.doubleToLongBits(value.doubleValue());
            return new short[]{(short)(l >> 48), (short)(l >> 32), (short)(l >> 16), (short)l};
        }
        if (this.dataType == 15) {
            long l = Double.doubleToLongBits(value.doubleValue());
            return new short[]{(short)l, (short)(l >> 16), (short)(l >> 32), (short)(l >> 48)};
        }
        throw new RuntimeException("Unsupported data type: " + this.dataType);
    }

    private short toShort(Number value) {
        return (short)this.toInt(value);
    }

    private int toInt(Number value) {
        if (value instanceof Double) {
            return new BigDecimal(value.doubleValue()).setScale(0, this.roundingMode).intValue();
        }
        if (value instanceof Float) {
            return new BigDecimal(value.floatValue()).setScale(0, this.roundingMode).intValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(0, this.roundingMode).intValue();
        }
        return value.intValue();
    }
}

