/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.ip.xa;

import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.ip.IpMessage;
import com.serotonin.modbus4j.msg.ModbusMessage;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public class XaMessage
extends IpMessage {
    protected final int transactionId;

    public XaMessage(ModbusMessage modbusMessage, int transactionId) {
        super(modbusMessage);
        this.transactionId = transactionId;
    }

    public byte[] getMessageData() {
        ByteQueue msgQueue = new ByteQueue();
        this.modbusMessage.write(msgQueue);
        ByteQueue xaQueue = new ByteQueue();
        ModbusUtils.pushShort(xaQueue, this.transactionId);
        ModbusUtils.pushShort(xaQueue, 0);
        ModbusUtils.pushShort(xaQueue, msgQueue.size());
        xaQueue.push(msgQueue);
        return xaQueue.popAll();
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @Override
    public ModbusMessage getModbusMessage() {
        return this.modbusMessage;
    }

    public String toString() {
        return "XaMessage [transactionId=" + this.transactionId + ", message=" + this.modbusMessage + "]";
    }
}

