/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j;

import com.junxin.modbus4j.AnalysisResponse;
import com.serotonin.modbus4j.ModbusFactory;
import com.serotonin.modbus4j.ModbusMaster;
import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.ip.IpParameters;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.msg.ReadHoldingRegistersRequest;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public class GetMessageFromGatewayUtil {
    static ModbusFactory modbusFactory;

    public static String[] modbusRTCP(String ip, int port, int salveId, int start, int readLenth) {
        ModbusMaster tcpMaster = GetMessageFromGatewayUtil.getTcpMaster(ip, port, salveId);
        if (tcpMaster == null) {
            System.out.println("tcpMaster is null ");
            return null;
        }
        return GetMessageFromGatewayUtil.modbusRTCP0(ip, port, salveId, start, readLenth, tcpMaster);
    }

    public static ModbusMaster getTcpMaster(String ip, int port, int salveId) {
        IpParameters params = new IpParameters();
        params.setHost(ip);
        if (port == 0) {
            params.setPort(502);
        } else {
            params.setPort(port);
        }
        ModbusMaster tcpMaster = modbusFactory.createTcpMaster(params, true);
        return tcpMaster;
    }

    public static String[] modbusRTCP0(String ip, int port, int salveId, int start, int readLenth, ModbusMaster tcpMaster) {
        if (tcpMaster == null) {
            System.out.println("tcpMaster is null");
            return null;
        }
        if ((tcpMaster = GetMessageFromGatewayUtil.initTcpMaster(tcpMaster)) == null) {
            System.out.println("tcpMaster is null");
            return null;
        }
        ModbusRequest modbusRequest = GetMessageFromGatewayUtil.getRequest(salveId, start, readLenth, tcpMaster);
        if (modbusRequest == null) {
            System.out.println("request is null");
            return null;
        }
        ModbusResponse response = GetMessageFromGatewayUtil.getModbusResponse(tcpMaster, modbusRequest);
        ByteQueue byteQueue = new ByteQueue(12);
        response.write(byteQueue);
        byteQueue.toString();
        String[] result = byteQueue.toString().replace("[", "").replace("]", "").split(",");
        for (int i = 0; i < result.length; ++i) {
            if (result[i].length() != 1) continue;
            result[i] = "0" + result[i];
        }
        return result;
    }

    public static ModbusMaster initTcpMaster(ModbusMaster tcpMaster) {
        if (tcpMaster == null) {
            return null;
        }
        try {
            tcpMaster.init();
            return tcpMaster;
        }
        catch (ModbusInitException e) {
            return null;
        }
    }

    public static ModbusRequest getRequest(int salveId, int start, int readLenth, ModbusMaster tcpMaster) {
        ReadHoldingRegistersRequest modbusRequest = null;
        try {
            modbusRequest = new ReadHoldingRegistersRequest(salveId, start, readLenth);
            return modbusRequest;
        }
        catch (ModbusTransportException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ModbusResponse getModbusResponse(ModbusMaster tcpMaster, ModbusRequest request) {
        ModbusResponse modbusResponse = null;
        try {
            modbusResponse = tcpMaster.send(request);
            return modbusResponse;
        }
        catch (ModbusTransportException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AnalysisResponse getRegisterData(String ip, int port, int slaveId, int offset, int readLength) {
        String[] result = GetMessageFromGatewayUtil.modbusRTCP(ip, port, slaveId, offset, readLength);
        AnalysisResponse analysisResponse = new AnalysisResponse();
        analysisResponse = analysisResponse.analysisResponsePacket(result);
        return analysisResponse;
    }

    static {
        if (modbusFactory == null) {
            modbusFactory = new ModbusFactory();
        }
    }
}

