
/*
 * Copyright (C), 2013-2018, 北京君信微科科技有限公司
 * FileName: dataType.java
 * Author:   zhangguida
 * Date:     2018年5月16日 下午1:46:07
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.junxin.modbus4j;


/** 
 * 功能描述: 数据代码与名称的对应关系
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author zhangguida
 * Date:   2018年5月16日 下午1:46:07
 */

public enum DataType {
    T1 (0x01, "温度"),
    T2 (0x02, "湿度"),
    T3 (0x03, "照度"),
    T4 (0x04, "土壤温度"),
    T5 (0x05, "土壤水分"),
    T6 (0x06, "大气压力"),
    T7 (0x07, "压力/液位"),
    T8 (0x08, "流量"),
    T9 (0x09, "超声波"),
    T10(0x0A, "雷达"),
    T11(0x0B, "单界面"),
    T12(0x0C, "双界面"),
    T13(0x0D, "浸水"),
    T14(0x0E, "感烟器"),
    T15(0x0F, "明火探测器"),
    T16(0x10, "红外探测器"),
    T17(0x11, "射频物位开关"),
    T18(0x12, "浮球开关"),
    T19(0x13, "音叉物位开关"),
    T20(0x14, "CO2"),
    T21(0x15, "粉尘"),
    T22(0x16, "空气质量等级"),
    T23(0x17, "CO"),
    T24(0x18, "H2"),
    T25(0x19, "H2S"),
    T26(0x1A, "O2"),
    T27(0x1B, "SO2"),
    T28(0x1C, "CL2"),
    T29(0x1D, "NH3"),
    T30(0x1E, "CH3OH"),
    T31(0x1F, "CH3CH2OH"),
    T32(0x20, "CH4"),
    T33(0x21, "露点"),
    T34(0x30, "风速"),
    T35(0x31, "风向"),
    T36(0x32, "雨量"),
    T37(0x80, "压力液位 Pa"),
    T38(0x81, "压力液位 kPa"),
    T39(0x82, "压力液位 MPa"),
    T40(0x83, "压力液位 Bar"),
    T41(0x84, "压力液位 m"),
    T42(0x85, "压力液位(预留)"),
    T43(0xA1, "开关量 1(输出)"),
    T44(0xA2, "开关量 2(输出)"),
    T45(0xA3, "开关量 3(输出)"),
    T46(0xA4, "开关量 4(输出)"),
    T47(0xA5, "开关量 5(输出)"),
    T48(0xA6, "开关量 6(输出)"),
    T49(0xA7, "开关量 7(输出)"),
    T50(0xA8, "开关量 8(输出)"),
    T51(0xB1, "开关量 1(输入)"),
    T52(0xB2, "开关量 2(输入)"),
    T53(0xB3, "开关量 3(输入)"),
    T54(0xB4, "开关量 4(输入)"),
    T55(0xC0, "模拟量 1(mA)"),
    T56(0xC1, "模拟量 2(mA)"),
    T57(0xC2, "模拟量 3(mA)"),
    T58(0xC3, "模拟量 4(mA)"),
    T59(0xC4, "模拟量 5(mA)"),
    T60(0xC5, "模拟量 6(mA)"),
    T61(0xC6, "模拟量 7(mA)"),
    T62(0xC7, "模拟量 8(mA)"),
    T63(0xC8, "模拟量 1(V)"),
    T64(0xC9, "模拟量 2(V)"),
    T65(0xCA, "模拟量 3(V)"),
    T66(0xCB, "模拟量 4(V)"),
    T67(0xCC, "模拟量 5(V)"),
    T68(0xCD, "模拟量 6(V)"),
    T69(0xCE, "模拟量 7(V)"),
    T70(0xCF, "模拟量 8(V)"),
    T71(0xE0, "数据传输"),
    T72(0xF0, "设备名称"),
    T73(0xF1, "设备版本"),
    T74(0xF2, "设备电量"),
    T75(0xFF, "路由心跳");

    int value;  
    String name;  
      
    DataType(int value, String name) {  
        this.value = value;  
        this.name = name;  
    }  
      
    public int getValue() {  
        return value;  
    }  
      
    public String getName() {  
        return name;  
    }  
  
    /**
     * 
     * 功能描述: 根据数据代码返回所对应的类型
     * 
     * @param value
     * @return 
     * String 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月16日 下午2:20:53
     */
    public static String getNameByValue(int value) {  
        for(DataType typeEnum : DataType.values()) {  
            if(typeEnum.value == value) {  
                return typeEnum.name;  
            }  
        }  
        throw new IllegalArgumentException("No element matches " + value);  
    }  
}

