
/*
 * Copyright (C), 2013-2018, 北京君信微科科技有限公司
 * FileName: abnormalCode.java
 * Author:   zhangguida
 * Date:     2018年5月16日 下午2:39:45
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.junxin.modbus4j;


/** 
 * 功能描述: 
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author zhangguida
 * Date:   2018年5月16日 下午2:39:45
 */
public enum AbnormalCodeType {
    T1 (0x01, "功能码错误"),
    T2 (0x02, "起始地址错误"),
    T3 (0x03, "寄存器数量错误"),
    T4 (0x04, "从站设备故障(如设备不在线)"),
    T5 (0x0C, "协议标识符错误"),
    T6 (0x0D, "请求包长度错误"),
    T7 (0x0E, "设备地址错误"),
    T8 (0x0F, "请求包的寄存器内容错误");
    
    int value;  
    String name;  
      
    AbnormalCodeType(int value, String name) {  
        this.value = value;  
        this.name = name;  
    }  
      
    public int getValue() {  
        return value;  
    }  
      
    public String getName() {  
        return name;  
    }  
  
    /**
     * 
     * 功能描述: 根据数据代码返回所对应的类型
     * 
     * @param value
     * @return 
     * String 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月16日 下午2:20:53
     */
    public static String getNameByValue(int value) {  
        for(AbnormalCodeType typeEnum : AbnormalCodeType.values()) {  
            if(typeEnum.value == value) {  
                return typeEnum.name;  
            }  
        }  
        throw new IllegalArgumentException("No element matches " + value);  
    }  
}
