/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j;

import com.junxin.modbus4j.DataType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class AnalysisResponse {
    private static final String MSG_SUCCESS = "\u89e3\u6790\u6210\u529f";
    private static final String MSG_FAIL = "\u89e3\u6790\u5931\u8d25";
    private static final int START_INDEX = 3;
    private boolean state;
    private String msg;
    private Map<String, String> data;

    public AnalysisResponse analysisResponsePacket(String[] rp) {
        AnalysisResponse af = new AnalysisResponse();
        String dataTypeName = null;
        String data = null;
        int indexTemp = 0;
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == rp || 0 == rp.length) {
            af.setState(false);
            af.setMsg(MSG_FAIL);
        } else {
            for (int i = 3; i < rp.length; ++i) {
                if (indexTemp == 0) {
                    if ("00".equals(rp[i])) continue;
                    dataTypeName = DataType.getNameByValue(Integer.parseInt(rp[i], 16));
                } else if (indexTemp == 1) {
                    String low;
                    String high;
                    String numType = rp[i].substring(0, 1);
                    String numDecimal = rp[i].substring(1, 2);
                    if (Integer.parseInt(numType, 16) == 4) {
                        data = "ffff".equalsIgnoreCase(rp[++i] + rp[++i]) ? "1" : "0";
                    } else if (Integer.parseInt(numType, 16) == 0) {
                        data = this.getData(numDecimal, false, rp[++i] + rp[++i], 16);
                    } else if (Integer.parseInt(numType, 16) == 8) {
                        data = this.getData(numDecimal, true, rp[++i] + rp[++i], 16);
                    } else if (Integer.parseInt(numType, 16) == 2) {
                        String low2 = rp[++i] + rp[++i];
                        i += 2;
                        String high2 = rp[++i] + rp[++i];
                        data = this.getData(numDecimal, false, high2 + low2, 32);
                    } else if (Integer.parseInt(numType, 16) == 3) {
                        high = rp[++i] + rp[++i];
                        i += 2;
                        low = rp[++i] + rp[++i];
                        data = this.getData(numDecimal, false, high + low, 32);
                    } else if (Integer.parseInt(numType, 16) == 10) {
                        high = rp[++i] + rp[++i];
                        i += 2;
                        low = rp[++i] + rp[++i];
                        data = this.getData(numDecimal, false, high + low, 32);
                    } else if (Integer.parseInt(numType, 16) == 11) {
                        high = rp[++i] + rp[++i];
                        i += 2;
                        low = rp[++i] + rp[++i];
                        data = this.getData(numDecimal, false, high + low, 32);
                    }
                    result.put(dataTypeName, data);
                    indexTemp = 0;
                    continue;
                }
                ++indexTemp;
            }
            af.setData(result);
        }
        return af;
    }

    public boolean isState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public String getData(String numDecimalStr, boolean signed, String dataStr, int datalength) {
        int numDecimal = Integer.parseInt(numDecimalStr, 16);
        double temp = Math.pow(10.0, numDecimal);
        String result = null;
        int ret = 0;
        if (16 == datalength) {
            ret = signed ? (((ret = Integer.parseInt(dataStr, 16)) & 0x8000) > 0 ? ret - 65536 : ret) : Integer.parseInt(dataStr, 16);
        } else if (32 == datalength) {
            ret = signed ? ("f".equals(dataStr.subSequence(0, 1)) || "F".equals(dataStr.subSequence(0, 1)) ? new BigInteger("FF" + dataStr, 16).intValue() : new BigInteger("00" + dataStr, 16).intValue()) : Integer.parseInt(dataStr, 16);
        }
        result = temp != 0.0 ? String.valueOf((double)ret / temp) : String.valueOf(ret);
        return result;
    }
}

