/*
 * Copyright (C), 2013-2018, 北京君信微科科技有限公司
 * FileName: getMessageFromGateway.java
 * Author:   zhangguida
 * Date:     2018年5月17日 下午2:33:44
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.junxin.modbus4j;
import com.serotonin.modbus4j.ModbusFactory;
import com.serotonin.modbus4j.ModbusMaster;
import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.ip.IpParameters;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.msg.ReadHoldingRegistersRequest;
import com.serotonin.util.queue.ByteQueue;

/**
 * 功能描述:读取网关中数据的相关方法
 * 
 * @version 1.0.0
 * @since 1.0.0
 * @author zhangguida Date: 2018年5月17日 下午2:33:44
 */

public class GetMessageFromGatewayUtil {
    
    static ModbusFactory modbusFactory;                  
    static {
        if (modbusFactory == null) {
            modbusFactory = new ModbusFactory();
        }
    }
    
    
    /**
     * 
     * 功能描述: 向网关发送请求并接收返回数据包
     * 
     * @param ip    网关地址
     * @param port  网关端口
     * @param salveId   设备地址
     * @param start     起始位置
     * @param readLenth 读取长度
     * @return 
     * ByteQueue 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午2:53:44
     */
    public static String[] modbusRTCP(String ip,int port,int salveId,int start,int readLenth) {
        ModbusMaster tcpMaster = getTcpMaster(ip, port, salveId);// 得到tcpMaster
        if (tcpMaster == null) {
            System.out.println("tcpMaster is null ");
            return null;
        }
        return modbusRTCP0(ip, port, salveId, start, readLenth, tcpMaster);
    }

    /**
     * 
     * 功能描述: 创建服务端
     * 
     * @param ip    网关地址
     * @param port  网关端口
     * @param salveId   设备地址
     * @return 
     * ModbusMaster 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午2:55:51
     */
    public static ModbusMaster getTcpMaster(String ip,int port,int salveId) {
        IpParameters params = new IpParameters();
        params.setHost(ip);// 设置ip
        if (port == 0)
            params.setPort(502);// 设置端口，默认为502
        else
            params.setPort(port);
        ModbusMaster tcpMaster = modbusFactory.createTcpMaster(params, true);// 获取ModbusMaster对象
        return tcpMaster;
    }
    
    /**
     * 
     * 功能描述: 初始化服务端封装请求包并获取返回数据包
     * 
     * @param ip
     * @param port
     * @param salveId
     * @param start
     * @param readLenth
     * @param tcpMaster
     * @return 
     * ByteQueue 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午2:58:13
     */
    public static String[] modbusRTCP0(String ip,int port,int salveId,int start,int readLenth,ModbusMaster tcpMaster) {
        if (tcpMaster == null) {
            System.out.println("tcpMaster is null");
            return null;
        }
        tcpMaster = initTcpMaster(tcpMaster);// 初始化tcpmaster

        if (tcpMaster == null) {
            System.out.println("tcpMaster is null");
            return null;
        }
        ModbusRequest modbusRequest = getRequest(salveId, start, readLenth, tcpMaster);// 得到requst 对象

        if (modbusRequest == null) {
            System.out.println("request is null");
            return null;
        }
        ModbusResponse response = getModbusResponse(tcpMaster, modbusRequest);// 发送请求，得到Response

        ByteQueue byteQueue = new ByteQueue(12);
        response.write(byteQueue);
        byteQueue.toString();
        String[] result = byteQueue.toString().replace("[", "").replace("]", "").split(",");
        for (int i = 0; i < result.length; i++) {
            if (result[i].length() == 1) {
                result[i] = "0" + result[i];
            }
        }
        return result;
    }
    
    /**
     * 
     * 功能描述:初始化服务端 
     * 
     * @param tcpMaster
     * @return 
     * ModbusMaster 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午3:01:47
     */
    public static ModbusMaster initTcpMaster(ModbusMaster tcpMaster) {
        if (tcpMaster == null)return null;
        try {
            tcpMaster.init();
            return tcpMaster;
        } catch (ModbusInitException e) {
            return null;
        }
    }
    
    /**
     * 
     * 功能描述: 封装请求包
     * 
     * @param salveId
     * @param start
     * @param readLenth
     * @param tcpMaster
     * @return 
     * ModbusRequest 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午3:02:04
     */
    public static ModbusRequest getRequest(int salveId,int start,int readLenth,ModbusMaster tcpMaster) {
        ModbusRequest modbusRequest = null;
        try {
            modbusRequest = new ReadHoldingRegistersRequest(salveId, start, readLenth);
            return modbusRequest;
        } catch (ModbusTransportException e) {
            e.printStackTrace();
            return null;
        }
    }

     /**
      *    
      * 功能描述: 发送请求包并获取返回数据包
      * 
      * @param tcpMaster
      * @param request
      * @return 
      * ModbusResponse 
      * @version 1.0.0 
      * @since 1.0.0 
      * @author zhangguida 
      * Date:   2018年5月17日 下午3:02:43
      */
    public static ModbusResponse getModbusResponse(ModbusMaster tcpMaster,
                                                   ModbusRequest request) {
        ModbusResponse modbusResponse = null;
        try {
            modbusResponse = tcpMaster.send(request);
            return modbusResponse;
        } catch (ModbusTransportException e) {
            e.printStackTrace();
            return null;
        }
    }
    
    /**
     * 
     * 功能描述: 读取网关中寄存器数据
     * 
     * @param ip
     * @param port
     * @param slaveId
     * @param offset
     * @param readLength
     * @return 
     * AnalysisResponse 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午3:48:35
     */
    public static AnalysisResponse getRegisterData (String ip,int port,int slaveId,int offset,int readLength) {
        String[] result = GetMessageFromGatewayUtil.modbusRTCP(ip, port, slaveId,offset, readLength);
        AnalysisResponse analysisResponse=new AnalysisResponse();
        analysisResponse = analysisResponse.analysisResponsePacket(result);
        return analysisResponse;
    }
    
}
