
/*
 * Copyright (C), 2013-2018, 北京君信微科科技有限公司
 * FileName: analysisFunction.java
 * Author:   zhangguida
 * Date:     2018年5月16日 上午11:52:07
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.junxin.modbus4j;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/** 
 * 功能描述: 解析物联网网关返回值
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author zhangguida
 * Date:   2018年5月16日 上午11:52:07
 */

public class AnalysisResponse {
    
    private static final String MSG_SUCCESS="解析成功";
    private static final String MSG_FAIL="解析失败";
    private static final int START_INDEX=3;
    
    private boolean state;
    
    private String msg;
    
    private Map<String, String> data;
    
    /**
     * 
     * 功能描述: 解析物联网网关返回值
     * 
     * @param rp 返回的数据包
     * @return 
     * analysisFunction 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author zhangguida 
     * Date:   2018年5月17日 下午2:41:28
     */
    public AnalysisResponse analysisResponsePacket(String [] rp) {
        AnalysisResponse af=new AnalysisResponse();
        
        String dataTypeName=null;
        String data=null;
        int indexTemp=0;
        
        Map<String, String>result=new HashMap<>();
        if (null==rp||0==rp.length) {
            af.setState(false);
            af.setMsg(MSG_FAIL);
        }
        else {
            for (int i = START_INDEX; i < rp.length; i++) {
                if (indexTemp==0) {
                    if ("00".equals(rp[i])) {
                        continue;
                    }
                    dataTypeName=DataType.getNameByValue(Integer.parseInt(rp[i],16));
                }else if (indexTemp==1) {
                    String numType=rp[i].substring(0, 1);
                    String numDecimal=rp[i].substring(1, 2);
                    if (Integer.parseInt(numType,16)==0x4) {
                        if ("ffff".equalsIgnoreCase(rp[++i]+rp[++i])) {
                            data="1";
                        }
                        else {
                            data="0";
                        }
                    }else if (Integer.parseInt(numType,16)==0x0) {
                        data=getData(numDecimal, false, rp[++i]+rp[++i],16);
                    }else if (Integer.parseInt(numType,16)==0x8) {
                        data=getData(numDecimal, true, rp[++i]+rp[++i],16);
                    }else if (Integer.parseInt(numType,16)==0x2) {
                        String low=rp[++i]+rp[++i];
                        i=i+2;
                        String high=rp[++i]+rp[++i];
                        data=getData(numDecimal, false, high+low,32);
                    }else if (Integer.parseInt(numType,16)==0x3) {
                        String high=rp[++i]+rp[++i];
                        i=i+2;
                        String low=rp[++i]+rp[++i];
                        data=getData(numDecimal, false, high+low,32);
                    }else if (Integer.parseInt(numType,16)==0xa) {
                        String high=rp[++i]+rp[++i];
                        i=i+2;
                        String low=rp[++i]+rp[++i];
                        data=getData(numDecimal, false, high+low,32);
                    }else if (Integer.parseInt(numType,16)==0xb) {
                        String high=rp[++i]+rp[++i];
                        i=i+2;
                        String low=rp[++i]+rp[++i];
                        data=getData(numDecimal, false, high+low,32);
                    }
                    result.put(dataTypeName, data);
                    indexTemp=0;
                    continue;
                }
                indexTemp++;
            }
            af.setData(result);
        }
        return af;
    }
    
    
    /**
     * @return the state
     */
    
    public boolean isState() {
    
        return state;
    }



    
    /**
     * @param state the state to set
     */
    
    public void setState(boolean state) {
        this.state = state;
    }



    
    /**
     * @return the msg
     */
    
    public String getMsg() {
    
        return msg;
    }



    
    /**
     * @param msg the msg to set
     */
    
    public void setMsg(String msg) {
        this.msg = msg;
    }



    
    /**
     * @return the data
     */
    
    public Map<String, String> getData() {
    
        return data;
    }



    
    /**
     * @param data the data to set
     */
    
    public void setData(Map<String, String> data) {
        this.data = data;
    }
    
    
    
    public String getData(String numDecimalStr,boolean signed,String dataStr,int datalength) {
        int numDecimal=Integer.parseInt(numDecimalStr,16);
        double temp=Math.pow(10, numDecimal);
        String result=null;
        int ret=0;
        if (16==datalength) {
            if (signed) {
                ret = Integer.parseInt(dataStr, 16);  
                ret = ((ret & 0x8000) > 0) ? (ret - 0x10000) : (ret);
            } else {
                ret = Integer.parseInt(dataStr, 16);
            }
        }else if (32==datalength) {
            if (signed) {
                if ("f".equals(dataStr.subSequence(0, 1))||"F".equals(dataStr.subSequence(0, 1))){
                    ret= new BigInteger("FF"+dataStr, 16).intValue();
                } else {
                    ret= new BigInteger("00"+dataStr, 16).intValue();
                }
            }else{
                ret = Integer.parseInt(dataStr, 16);
            }
        }
        
        if (temp!=0) {
            result=String.valueOf(ret/temp);
        }
        else {
            result=String.valueOf(ret);
        }
        return result;
    }
}
