/*
 * ============================================================================
 * GNU General Public License
 * ============================================================================
 *
 * Copyright (C) 2006-2011 Serotonin Software Technologies Inc. http://serotoninsoftware.com
 * @author Matthew Lohbihler
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

/**
 * @author Matthew Lohbihler
 */
public class ExceptionResponse extends ModbusResponse {
    private final byte functionCode;

    public ExceptionResponse(int slaveId, byte functionCode, byte exceptionCode) throws ModbusTransportException {
        super(slaveId);
        this.functionCode = functionCode;
        setException(exceptionCode);
    }

    @Override
    public byte getFunctionCode() {
        return functionCode;
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        // no op
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        // no op
    }
}
