/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.sero.util.queue;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ByteQueue
implements Cloneable {
    private byte[] queue;
    private int head = -1;
    private int tail = 0;
    private int size = 0;
    private int markHead;
    private int markTail;
    private int markSize;

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int initialLength) {
        this.queue = new byte[initialLength];
    }

    public ByteQueue(byte[] b) {
        this(b.length);
        this.push(b, 0, b.length);
    }

    public ByteQueue(byte[] b, int pos, int length) {
        this(length);
        this.push(b, pos, length);
    }

    public ByteQueue(String hex) {
        this(hex.length() / 2);
        this.push(hex);
    }

    public void push(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex string must have an even number of characters");
        }
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
        }
        this.push(b, 0, b.length);
    }

    public void push(byte b) {
        if (this.room() == 0) {
            this.expand();
        }
        this.queue[this.tail] = b;
        if (this.head == -1) {
            this.head = 0;
        }
        this.tail = (this.tail + 1) % this.queue.length;
        ++this.size;
    }

    public void push(int i) {
        this.push((byte)i);
    }

    public void push(long l) {
        this.push((byte)l);
    }

    public void pushU2B(int i) {
        this.push((byte)(i >> 8));
        this.push((byte)i);
    }

    public void pushU3B(int i) {
        this.push((byte)(i >> 16));
        this.push((byte)(i >> 8));
        this.push((byte)i);
    }

    public void pushS4B(int i) {
        this.pushInt(i);
    }

    public void pushU4B(long l) {
        this.push((byte)(l >> 24));
        this.push((byte)(l >> 16));
        this.push((byte)(l >> 8));
        this.push((byte)l);
    }

    public void pushChar(char c) {
        this.push((byte)(c >> 8));
        this.push((byte)c);
    }

    public void pushDouble(double d) {
        this.pushLong(Double.doubleToLongBits(d));
    }

    public void pushFloat(float f) {
        this.pushInt(Float.floatToIntBits(f));
    }

    public void pushInt(int i) {
        this.push((byte)(i >> 24));
        this.push((byte)(i >> 16));
        this.push((byte)(i >> 8));
        this.push((byte)i);
    }

    public void pushLong(long l) {
        this.push((byte)(l >> 56));
        this.push((byte)(l >> 48));
        this.push((byte)(l >> 40));
        this.push((byte)(l >> 32));
        this.push((byte)(l >> 24));
        this.push((byte)(l >> 16));
        this.push((byte)(l >> 8));
        this.push((byte)l);
    }

    public void pushShort(short s) {
        this.push((byte)(s >> 8));
        this.push((byte)s);
    }

    public void read(InputStream in, int length) throws IOException {
        if (length == 0) {
            return;
        }
        while (this.room() < length) {
            this.expand();
        }
        int tailLength = this.queue.length - this.tail;
        if (tailLength > length) {
            this.readImpl(in, this.tail, length);
        } else {
            this.readImpl(in, this.tail, tailLength);
        }
        if (length > tailLength) {
            this.readImpl(in, 0, length - tailLength);
        }
        if (this.head == -1) {
            this.head = 0;
        }
        this.tail = (this.tail + length) % this.queue.length;
        this.size += length;
    }

    private void readImpl(InputStream in, int offset, int length) throws IOException {
        while (length > 0) {
            int readcount = in.read(this.queue, offset, length);
            offset += readcount;
            length -= readcount;
        }
    }

    public void push(byte[] b) {
        this.push(b, 0, b.length);
    }

    public void push(byte[] b, int pos, int length) {
        if (length == 0) {
            return;
        }
        while (this.room() < length) {
            this.expand();
        }
        int tailLength = this.queue.length - this.tail;
        if (tailLength > length) {
            System.arraycopy(b, pos, this.queue, this.tail, length);
        } else {
            System.arraycopy(b, pos, this.queue, this.tail, tailLength);
        }
        if (length > tailLength) {
            System.arraycopy(b, tailLength + pos, this.queue, 0, length - tailLength);
        }
        if (this.head == -1) {
            this.head = 0;
        }
        this.tail = (this.tail + length) % this.queue.length;
        this.size += length;
    }

    public void push(ByteQueue source) {
        int firstCopyLen;
        if (source.size == 0) {
            return;
        }
        if (source == this) {
            source = (ByteQueue)this.clone();
        }
        if (source.size < (firstCopyLen = source.queue.length - source.head)) {
            firstCopyLen = source.size;
        }
        this.push(source.queue, source.head, firstCopyLen);
        if (firstCopyLen < source.size) {
            this.push(source.queue, 0, source.tail);
        }
    }

    public void push(ByteQueue source, int len) {
        while (len-- > 0) {
            this.push(source.pop());
        }
    }

    public void push(ByteBuffer source) {
        int length = source.remaining();
        if (length == 0) {
            return;
        }
        while (this.room() < length) {
            this.expand();
        }
        int tailLength = this.queue.length - this.tail;
        if (tailLength > length) {
            source.get(this.queue, this.tail, length);
        } else {
            source.get(this.queue, this.tail, tailLength);
        }
        if (length > tailLength) {
            source.get(this.queue, 0, length - tailLength);
        }
        if (this.head == -1) {
            this.head = 0;
        }
        this.tail = (this.tail + length) % this.queue.length;
        this.size += length;
    }

    public void mark() {
        this.markHead = this.head;
        this.markTail = this.tail;
        this.markSize = this.size;
    }

    public void reset() {
        this.head = this.markHead;
        this.tail = this.markTail;
        this.size = this.markSize;
    }

    public byte pop() {
        byte retval = this.queue[this.head];
        if (this.size == 1) {
            this.head = -1;
            this.tail = 0;
        } else {
            this.head = (this.head + 1) % this.queue.length;
        }
        --this.size;
        return retval;
    }

    public int popU1B() {
        return this.pop() & 0xFF;
    }

    public int popU2B() {
        return (this.pop() & 0xFF) << 8 | this.pop() & 0xFF;
    }

    public int popU3B() {
        return (this.pop() & 0xFF) << 16 | (this.pop() & 0xFF) << 8 | this.pop() & 0xFF;
    }

    public short popS2B() {
        return (short)((this.pop() & 0xFF) << 8 | this.pop() & 0xFF);
    }

    public int popS4B() {
        return (this.pop() & 0xFF) << 24 | (this.pop() & 0xFF) << 16 | (this.pop() & 0xFF) << 8 | this.pop() & 0xFF;
    }

    public long popU4B() {
        return (long)(this.pop() & 0xFF) << 24 | (long)(this.pop() & 0xFF) << 16 | (long)(this.pop() & 0xFF) << 8 | (long)(this.pop() & 0xFF);
    }

    public int pop(byte[] buf) {
        return this.pop(buf, 0, buf.length);
    }

    public int pop(byte[] buf, int pos, int length) {
        length = this.peek(buf, pos, length);
        this.size -= length;
        if (this.size == 0) {
            this.head = -1;
            this.tail = 0;
        } else {
            this.head = (this.head + length) % this.queue.length;
        }
        return length;
    }

    public int pop(int length) {
        if (length == 0) {
            return 0;
        }
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        if (length > this.size) {
            length = this.size;
        }
        this.size -= length;
        if (this.size == 0) {
            this.head = -1;
            this.tail = 0;
        } else {
            this.head = (this.head + length) % this.queue.length;
        }
        return length;
    }

    public String popString(int length, Charset charset) {
        byte[] b = new byte[length];
        this.pop(b);
        return new String(b, charset);
    }

    public byte[] popAll() {
        byte[] data = new byte[this.size];
        this.pop(data, 0, data.length);
        return data;
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, this.size);
    }

    public void write(OutputStream out, int length) throws IOException {
        int firstCopyLen;
        if (length == 0) {
            return;
        }
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        if (length > this.size) {
            length = this.size;
        }
        if (length < (firstCopyLen = this.queue.length - this.head)) {
            firstCopyLen = length;
        }
        out.write(this.queue, this.head, firstCopyLen);
        if (firstCopyLen < length) {
            out.write(this.queue, 0, length - firstCopyLen);
        }
        this.size -= length;
        if (this.size == 0) {
            this.head = -1;
            this.tail = 0;
        } else {
            this.head = (this.head + length) % this.queue.length;
        }
    }

    public byte tailPop() {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        this.tail = (this.tail + this.queue.length - 1) % this.queue.length;
        byte retval = this.queue[this.tail];
        if (this.size == 1) {
            this.head = -1;
            this.tail = 0;
        }
        --this.size;
        return retval;
    }

    public byte peek(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("index " + index + " is >= queue size " + this.size);
        }
        index = (index + this.head) % this.queue.length;
        return this.queue[index];
    }

    public byte[] peek(int index, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.peek(index + i);
        }
        return result;
    }

    public byte[] peekAll() {
        byte[] data = new byte[this.size];
        this.peek(data, 0, data.length);
        return data;
    }

    public int peek(byte[] buf) {
        return this.peek(buf, 0, buf.length);
    }

    public int peek(byte[] buf, int pos, int length) {
        int firstCopyLen;
        if (length == 0) {
            return 0;
        }
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        if (length > this.size) {
            length = this.size;
        }
        if (length < (firstCopyLen = this.queue.length - this.head)) {
            firstCopyLen = length;
        }
        System.arraycopy(this.queue, this.head, buf, pos, firstCopyLen);
        if (firstCopyLen < length) {
            System.arraycopy(this.queue, 0, buf, pos + firstCopyLen, length - firstCopyLen);
        }
        return length;
    }

    public int indexOf(byte b) {
        return this.indexOf(b, 0);
    }

    public int indexOf(byte b, int start) {
        if (start >= this.size) {
            return -1;
        }
        int index = (this.head + start) % this.queue.length;
        for (int i = start; i < this.size; ++i) {
            if (this.queue[index] == b) {
                return i;
            }
            index = (index + 1) % this.queue.length;
        }
        return -1;
    }

    public int indexOf(byte[] b) {
        return this.indexOf(b, 0);
    }

    public int indexOf(byte[] b, int start) {
        if (b == null || b.length == 0) {
            throw new IllegalArgumentException("cannot search for empty values");
        }
        while ((start = this.indexOf(b[0], start)) != -1 && start < this.size - b.length + 1) {
            boolean found = true;
            for (int i = 1; i < b.length; ++i) {
                if (this.peek(start + i) == b[i]) continue;
                found = false;
                break;
            }
            if (found) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.head = -1;
        this.tail = 0;
    }

    private int room() {
        return this.queue.length - this.size;
    }

    private void expand() {
        byte[] newb = new byte[this.queue.length * 2];
        if (this.head == -1) {
            this.queue = newb;
            return;
        }
        if (this.tail > this.head) {
            System.arraycopy(this.queue, this.head, newb, this.head, this.tail - this.head);
            this.queue = newb;
            return;
        }
        System.arraycopy(this.queue, this.head, newb, this.head + this.queue.length, this.queue.length - this.head);
        System.arraycopy(this.queue, 0, newb, 0, this.tail);
        this.head += this.queue.length;
        this.queue = newb;
    }

    public Object clone() {
        try {
            ByteQueue clone = (ByteQueue)super.clone();
            clone.queue = (byte[])this.queue.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(Integer.toHexString(this.peek(0) & 0xFF));
        for (int i = 1; i < this.size; ++i) {
            sb.append(',').append(Integer.toHexString(this.peek(i) & 0xFF));
        }
        sb.append("]");
        return sb.toString();
    }

    public String dumpQueue() {
        StringBuffer sb = new StringBuffer();
        if (this.queue.length == 0) {
            sb.append("[]");
        } else {
            sb.append('[');
            sb.append(this.queue[0]);
            for (int i = 1; i < this.queue.length; ++i) {
                sb.append(", ");
                sb.append(this.queue[i]);
            }
            sb.append("]");
        }
        sb.append(", h=").append(this.head).append(", t=").append(this.tail).append(", s=").append(this.size);
        return sb.toString();
    }
}

