/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.sero.util;

import com.junxin.modbus4j.sero.util.ProgressiveTaskListener;

public abstract class ProgressiveTask
implements Runnable {
    private boolean cancelled = false;
    protected boolean completed = false;
    private ProgressiveTaskListener listener;

    public ProgressiveTask() {
    }

    public ProgressiveTask(ProgressiveTaskListener l) {
        this.listener = l;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public final void run() {
        block2: {
            do {
                if (this.isCancelled()) {
                    this.declareFinished(true);
                    break block2;
                }
                this.runImpl();
            } while (!this.isCompleted());
            this.declareFinished(false);
        }
        this.completed = true;
    }

    protected void declareProgress(float progress) {
        ProgressiveTaskListener l = this.listener;
        if (l != null) {
            l.progressUpdate(progress);
        }
    }

    private void declareFinished(boolean cancelled) {
        ProgressiveTaskListener l = this.listener;
        if (l != null) {
            if (cancelled) {
                l.taskCancelled();
            } else {
                l.taskCompleted();
            }
        }
    }

    protected abstract void runImpl();
}

