/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.sero.log;

import com.junxin.modbus4j.sero.io.NullWriter;
import com.junxin.modbus4j.sero.io.StreamUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseIOLog {
    private static final Log LOG = LogFactory.getLog(BaseIOLog.class);
    protected static final String DATE_FORMAT = "yyyy/MM/dd-HH:mm:ss,SSS";
    protected final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss,SSS");
    protected PrintWriter out;
    protected final File file;
    protected final StringBuilder sb = new StringBuilder();
    protected final Date date = new Date();

    public BaseIOLog(File logFile) {
        this.file = logFile;
        this.createOut();
    }

    protected void createOut() {
        try {
            this.out = new PrintWriter(new FileWriter(this.file, true));
        }
        catch (IOException e) {
            this.out = new PrintWriter(new NullWriter());
            LOG.error((Object)"Error while creating process log", (Throwable)e);
        }
    }

    public void close() {
        this.out.close();
    }

    public void input(byte[] b) {
        this.log(true, b, 0, b.length);
    }

    public void input(byte[] b, int pos, int len) {
        this.log(true, b, pos, len);
    }

    public void output(byte[] b) {
        this.log(false, b, 0, b.length);
    }

    public void output(byte[] b, int pos, int len) {
        this.log(false, b, pos, len);
    }

    public void log(boolean input, byte[] b) {
        this.log(input, b, 0, b.length);
    }

    public synchronized void log(boolean input, byte[] b, int pos, int len) {
        this.sizeCheck();
        this.sb.delete(0, this.sb.length());
        this.date.setTime(System.currentTimeMillis());
        this.sb.append(this.sdf.format(this.date)).append(" ");
        this.sb.append(input ? "I" : "O").append(" ");
        this.sb.append(StreamUtils.dumpHex(b, pos, len));
        this.out.println(this.sb.toString());
        this.out.flush();
    }

    public synchronized void log(String message) {
        this.sizeCheck();
        this.sb.delete(0, this.sb.length());
        this.date.setTime(System.currentTimeMillis());
        this.sb.append(this.sdf.format(this.date)).append(" ");
        this.sb.append(message);
        this.out.println(this.sb.toString());
        this.out.flush();
    }

    protected abstract void sizeCheck();
}

