/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteRegistersResponse
extends ModbusResponse {
    private int startOffset;
    private int numberOfRegisters;

    @Override
    public byte getFunctionCode() {
        return 16;
    }

    WriteRegistersResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    WriteRegistersResponse(int slaveId, int startOffset, int numberOfRegisters) throws ModbusTransportException {
        super(slaveId);
        this.startOffset = startOffset;
        this.numberOfRegisters = numberOfRegisters;
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.startOffset);
        ModbusUtils.pushShort(queue, this.numberOfRegisters);
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        this.startOffset = ModbusUtils.popUnsignedShort(queue);
        this.numberOfRegisters = ModbusUtils.popUnsignedShort(queue);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getNumberOfRegisters() {
        return this.numberOfRegisters;
    }
}

