/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.Modbus;
import com.junxin.modbus4j.ProcessImage;
import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusRequest;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.msg.WriteRegistersResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteRegistersRequest
extends ModbusRequest {
    private int startOffset;
    private byte[] data;

    public WriteRegistersRequest(int slaveId, int startOffset, short[] sdata) throws ModbusTransportException {
        super(slaveId);
        this.startOffset = startOffset;
        this.data = this.convertToBytes(sdata);
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.startOffset);
        int registerCount = this.data.length / 2;
        if (registerCount < 1 || registerCount > modbus.getMaxWriteRegisterCount()) {
            throw new ModbusTransportException("Invalid number of registers: " + registerCount, this.slaveId);
        }
        ModbusUtils.validateEndOffset(this.startOffset + registerCount - 1);
    }

    WriteRegistersRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.startOffset);
        ModbusUtils.pushShort(queue, this.data.length / 2);
        ModbusUtils.pushByte(queue, this.data.length);
        queue.push(this.data);
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        short[] sdata = this.convertToShorts(this.data);
        for (int i = 0; i < sdata.length; ++i) {
            processImage.writeHoldingRegister(this.startOffset + i, sdata[i]);
        }
        return new WriteRegistersResponse(this.slaveId, this.startOffset, sdata.length);
    }

    @Override
    public byte getFunctionCode() {
        return 16;
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new WriteRegistersResponse(slaveId);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.startOffset = ModbusUtils.popUnsignedShort(queue);
        ModbusUtils.popUnsignedShort(queue);
        this.data = new byte[ModbusUtils.popUnsignedByte(queue)];
        queue.pop(this.data);
    }
}

