/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteRegisterResponse
extends ModbusResponse {
    private int writeOffset;
    private int writeValue;

    @Override
    public byte getFunctionCode() {
        return 6;
    }

    WriteRegisterResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    WriteRegisterResponse(int slaveId, int writeOffset, int writeValue) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.writeValue = writeValue;
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.writeValue);
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.writeValue = ModbusUtils.popUnsignedShort(queue);
    }

    public int getWriteOffset() {
        return this.writeOffset;
    }

    public int getWriteValue() {
        return this.writeValue;
    }
}

