/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteCoilsResponse
extends ModbusResponse {
    private int startOffset;
    private int numberOfBits;

    @Override
    public byte getFunctionCode() {
        return 15;
    }

    WriteCoilsResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    WriteCoilsResponse(int slaveId, int startOffset, int numberOfBits) throws ModbusTransportException {
        super(slaveId);
        this.startOffset = startOffset;
        this.numberOfBits = numberOfBits;
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.startOffset);
        ModbusUtils.pushShort(queue, this.numberOfBits);
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        this.startOffset = ModbusUtils.popUnsignedShort(queue);
        this.numberOfBits = ModbusUtils.popUnsignedShort(queue);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }
}

