/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.Modbus;
import com.junxin.modbus4j.ProcessImage;
import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusIdException;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusRequest;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.msg.WriteMaskRegisterResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteMaskRegisterRequest
extends ModbusRequest {
    private int writeOffset;
    private int andMask;
    private int orMask;

    public WriteMaskRegisterRequest(int slaveId, int writeOffset) throws ModbusTransportException {
        this(slaveId, writeOffset, 65535, 0);
    }

    public WriteMaskRegisterRequest(int slaveId, int writeOffset, int andMask, int orMask) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.andMask = andMask;
        this.orMask = orMask;
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.writeOffset);
    }

    public void setBit(int bit, boolean value) {
        if (bit < 0 || bit > 15) {
            throw new ModbusIdException("Bit must be between 0 and 15 inclusive");
        }
        this.andMask &= ~(1 << bit);
        this.orMask = value ? (this.orMask |= 1 << bit) : (this.orMask &= ~(1 << bit));
    }

    WriteMaskRegisterRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.andMask);
        ModbusUtils.pushShort(queue, this.orMask);
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        short value = processImage.getHoldingRegister(this.writeOffset);
        value = (short)(value & this.andMask | this.orMask & ~this.andMask);
        processImage.writeHoldingRegister(this.writeOffset, value);
        return new WriteMaskRegisterResponse(this.slaveId, this.writeOffset, this.andMask, this.orMask);
    }

    @Override
    public byte getFunctionCode() {
        return 22;
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new WriteMaskRegisterResponse(slaveId);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.andMask = ModbusUtils.popUnsignedShort(queue);
        this.orMask = ModbusUtils.popUnsignedShort(queue);
    }
}

