/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteCoilResponse
extends ModbusResponse {
    private int writeOffset;
    private boolean writeValue;

    @Override
    public byte getFunctionCode() {
        return 5;
    }

    WriteCoilResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    WriteCoilResponse(int slaveId, int writeOffset, boolean writeValue) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.writeValue = writeValue;
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.writeValue ? 65280 : 0);
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.writeValue = ModbusUtils.popUnsignedShort(queue) == 65280;
    }

    public int getWriteOffset() {
        return this.writeOffset;
    }

    public boolean isWriteValue() {
        return this.writeValue;
    }
}

