/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.ip.udp;

import com.junxin.modbus4j.ModbusSlaveSet;
import com.junxin.modbus4j.base.BaseMessageParser;
import com.junxin.modbus4j.base.BaseRequestHandler;
import com.junxin.modbus4j.exception.ModbusInitException;
import com.junxin.modbus4j.ip.encap.EncapMessageParser;
import com.junxin.modbus4j.ip.encap.EncapRequestHandler;
import com.junxin.modbus4j.ip.xa.XaMessageParser;
import com.junxin.modbus4j.ip.xa.XaRequestHandler;
import com.junxin.modbus4j.sero.messaging.IncomingMessage;
import com.junxin.modbus4j.sero.messaging.IncomingRequestMessage;
import com.junxin.modbus4j.sero.messaging.OutgoingResponseMessage;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class UdpSlave
extends ModbusSlaveSet {
    private final int port;
    DatagramSocket datagramSocket;
    private final ExecutorService executorService;
    final BaseMessageParser messageParser;
    final BaseRequestHandler requestHandler;

    public UdpSlave(boolean encapsulated) {
        this(502, encapsulated);
    }

    public UdpSlave(int port, boolean encapsulated) {
        this.port = port;
        if (encapsulated) {
            this.messageParser = new EncapMessageParser(false);
            this.requestHandler = new EncapRequestHandler(this);
        } else {
            this.messageParser = new XaMessageParser(false);
            this.requestHandler = new XaRequestHandler(this);
        }
        this.executorService = Executors.newCachedThreadPool();
    }

    @Override
    public void start() throws ModbusInitException {
        try {
            this.datagramSocket = new DatagramSocket(this.port);
            while (true) {
                DatagramPacket datagramPacket = new DatagramPacket(new byte[1028], 1028);
                this.datagramSocket.receive(datagramPacket);
                UdpConnectionHandler handler = new UdpConnectionHandler(datagramPacket);
                this.executorService.execute(handler);
            }
        }
        catch (IOException e) {
            throw new ModbusInitException(e);
        }
    }

    @Override
    public void stop() {
        this.datagramSocket.close();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.getExceptionHandler().receivedException(e);
        }
    }

    class UdpConnectionHandler
    implements Runnable {
        private final DatagramPacket requestPacket;

        UdpConnectionHandler(DatagramPacket requestPacket) {
            this.requestPacket = requestPacket;
        }

        @Override
        public void run() {
            try {
                ByteQueue requestQueue = new ByteQueue(this.requestPacket.getData(), 0, this.requestPacket.getLength());
                IncomingMessage request = UdpSlave.this.messageParser.parseMessage(requestQueue);
                OutgoingResponseMessage response = UdpSlave.this.requestHandler.handleRequest((IncomingRequestMessage)request);
                if (response == null) {
                    return;
                }
                byte[] responseData = response.getMessageData();
                DatagramPacket responsePacket = new DatagramPacket(responseData, responseData.length, this.requestPacket.getAddress(), this.requestPacket.getPort());
                UdpSlave.this.datagramSocket.send(responsePacket);
            }
            catch (Exception e) {
                UdpSlave.this.getExceptionHandler().receivedException(e);
            }
        }
    }
}

