/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.serial.ascii;

import com.junxin.modbus4j.exception.ModbusInitException;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusRequest;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.serial.SerialMaster;
import com.junxin.modbus4j.serial.SerialPortWrapper;
import com.junxin.modbus4j.serial.SerialWaitingRoomKeyFactory;
import com.junxin.modbus4j.serial.ascii.AsciiMessageParser;
import com.junxin.modbus4j.serial.ascii.AsciiMessageRequest;
import com.junxin.modbus4j.serial.ascii.AsciiMessageResponse;
import com.junxin.modbus4j.sero.messaging.MessageControl;
import com.junxin.modbus4j.sero.messaging.StreamTransport;
import java.io.IOException;

public class AsciiMaster
extends SerialMaster {
    private MessageControl conn;

    public AsciiMaster(SerialPortWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public void init() throws ModbusInitException {
        super.init();
        AsciiMessageParser asciiMessageParser = new AsciiMessageParser(true);
        this.conn = this.getMessageControl();
        try {
            this.conn.start(this.transport, asciiMessageParser, null, new SerialWaitingRoomKeyFactory());
            if (this.getePoll() == null) {
                ((StreamTransport)this.transport).start("Modbus ASCII master");
            }
        }
        catch (IOException e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    public void destroy() {
        this.closeMessageControl(this.conn);
        super.close();
        this.initialized = false;
    }

    @Override
    public ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        AsciiMessageRequest asciiRequest = new AsciiMessageRequest(request);
        try {
            AsciiMessageResponse asciiResponse = (AsciiMessageResponse)this.conn.send(asciiRequest);
            if (asciiResponse == null) {
                return null;
            }
            return asciiResponse.getModbusResponse();
        }
        catch (Exception e) {
            throw new ModbusTransportException(e, request.getSlaveId());
        }
    }
}

