/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.sero.messaging;

import com.junxin.modbus4j.sero.messaging.IncomingResponseMessage;
import com.junxin.modbus4j.sero.messaging.WaitingRoomException;
import com.junxin.modbus4j.sero.messaging.WaitingRoomKey;
import com.junxin.modbus4j.sero.messaging.WaitingRoomKeyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class WaitingRoom {
    private static final Log LOG = LogFactory.getLog(WaitingRoom.class);
    private final Map<WaitingRoomKey, Member> waitHere = new HashMap<WaitingRoomKey, Member>();
    private WaitingRoomKeyFactory keyFactory;

    WaitingRoom() {
    }

    void setKeyFactory(WaitingRoomKeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter(WaitingRoomKey key) {
        Member member = new Member();
        WaitingRoom waitingRoom = this;
        synchronized (waitingRoom) {
            while (this.waitHere.get(key) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Duplicate waiting room key found. Waiting for member to leave.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.waitHere.put(key, member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IncomingResponseMessage getResponse(WaitingRoomKey key, long timeout) throws WaitingRoomException {
        Member member;
        WaitingRoom waitingRoom = this;
        synchronized (waitingRoom) {
            member = this.waitHere.get(key);
        }
        if (member == null) {
            throw new WaitingRoomException("No member for key " + key);
        }
        return member.getResponse(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leave(WaitingRoomKey key) {
        WaitingRoom waitingRoom = this;
        synchronized (waitingRoom) {
            this.waitHere.remove(key);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void response(IncomingResponseMessage response) throws WaitingRoomException {
        Member member;
        WaitingRoomKey key = this.keyFactory.createWaitingRoomKey(response);
        if (key == null) {
            return;
        }
        WaitingRoom waitingRoom = this;
        synchronized (waitingRoom) {
            member = this.waitHere.get(key);
        }
        if (member == null) {
            throw new WaitingRoomException("No recipient was found waiting for response for key " + key);
        }
        member.setResponse(response);
    }

    class Member {
        private IncomingResponseMessage response;

        Member() {
        }

        synchronized void setResponse(IncomingResponseMessage response) {
            this.response = response;
            this.notify();
        }

        synchronized IncomingResponseMessage getResponse(long timeout) {
            if (this.response != null) {
                return this.response;
            }
            this.waitNoThrow(timeout);
            return this.response;
        }

        private void waitNoThrow(long timeout) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

