/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.sero.log;

import com.junxin.modbus4j.sero.log.BaseIOLog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RollingIOLog
extends BaseIOLog {
    private static final Log LOG = LogFactory.getLog(RollingIOLog.class);
    protected int fileSize;
    protected int maxFiles;
    protected int currentFileNumber;

    public RollingIOLog(String baseFilename, File logDirectory, int fileSize, int maxFiles) {
        super(new File(logDirectory, baseFilename));
        this.createOut();
        File[] files = logDirectory.listFiles(new LogFilenameFilter(baseFilename));
        this.currentFileNumber = files.length - 1;
        if (this.currentFileNumber > maxFiles) {
            this.currentFileNumber = maxFiles;
        }
        this.fileSize = fileSize;
        this.maxFiles = maxFiles;
    }

    @Override
    protected void sizeCheck() {
        if (this.file.length() > (long)this.fileSize) {
            this.out.close();
            try {
                for (int i = this.currentFileNumber; i > 0; --i) {
                    Path source = Paths.get(this.file.getAbsolutePath() + "." + i, new String[0]);
                    Path target = Paths.get(this.file.getAbsolutePath() + "." + (i + 1), new String[0]);
                    Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
                Path source = Paths.get(this.file.toURI());
                Path target = Paths.get(this.file.getAbsolutePath() + "." + 1, new String[0]);
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                if (this.currentFileNumber < this.maxFiles - 1) {
                    ++this.currentFileNumber;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            this.createOut();
        }
    }

    class LogFilenameFilter
    implements FilenameFilter {
        private String nameToMatch;

        public LogFilenameFilter(String nameToMatch) {
            this.nameToMatch = nameToMatch;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.nameToMatch);
        }
    }
}

