/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.msg;

import com.junxin.modbus4j.base.ModbusUtils;
import com.junxin.modbus4j.exception.ModbusTransportException;
import com.junxin.modbus4j.msg.ModbusResponse;
import com.junxin.modbus4j.sero.util.queue.ByteQueue;

public class WriteMaskRegisterResponse
extends ModbusResponse {
    private int writeOffset;
    private int andMask;
    private int orMask;

    @Override
    public byte getFunctionCode() {
        return 22;
    }

    WriteMaskRegisterResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    WriteMaskRegisterResponse(int slaveId, int writeOffset, int andMask, int orMask) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.andMask = andMask;
        this.orMask = orMask;
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.andMask);
        ModbusUtils.pushShort(queue, this.orMask);
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.andMask = ModbusUtils.popUnsignedShort(queue);
        this.orMask = ModbusUtils.popUnsignedShort(queue);
    }

    public int getWriteOffset() {
        return this.writeOffset;
    }

    public int getAndMask() {
        return this.andMask;
    }

    public int getOrMask() {
        return this.orMask;
    }
}

