/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.modbus4j.value;

import com.junxin.modbus4j.code.DataType;
import com.junxin.modbus4j.exception.InvalidDataConversionException;
import java.math.BigInteger;

public abstract class ModbusValue {
    private final DataType type;
    private final Object value;

    public ModbusValue(DataType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public DataType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean booleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new InvalidDataConversionException("Can't convert " + this.value.getClass() + " to boolean");
    }

    public int intValue() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.value instanceof Short) {
            return (Short)this.value & 0xFFFF;
        }
        throw new InvalidDataConversionException("Can't convert " + this.value.getClass() + " to int");
    }

    public long longValue() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.value instanceof Integer) {
            return (Integer)this.value & 0xFFFFFFFF;
        }
        if (this.value instanceof Short) {
            return (Short)this.value & 0xFFFF;
        }
        throw new InvalidDataConversionException("Can't convert " + this.value.getClass() + " to long");
    }

    public BigInteger bigIntegerValue() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        if (this.value instanceof Long) {
            return BigInteger.valueOf((Long)this.value);
        }
        if (this.value instanceof Integer) {
            return BigInteger.valueOf((Integer)this.value & 0xFFFFFFFF);
        }
        if (this.value instanceof Short) {
            return BigInteger.valueOf((Short)this.value & 0xFFFF);
        }
        throw new InvalidDataConversionException("Can't convert " + this.value.getClass() + " to BigInteger");
    }

    public float floatValue() {
        if (this.value instanceof Float) {
            return ((Float)this.value).floatValue();
        }
        throw new InvalidDataConversionException("Can't convert " + this.value.getClass() + " to float");
    }

    public double doubleValue() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Float) {
            return ((Float)this.value).doubleValue();
        }
        throw new InvalidDataConversionException("Can't convert " + this.value.getClass() + " to float");
    }
}

